class TDP expands Mutator;

var float CheckTime;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	Level.Game.HUDType=Class'TDP_HUD';
	Level.Game.ScoreBoardType = Class'TDP_SB';
	Level.Game.GameName = "Adult DeathMatch";
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int X;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if (inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('ChainSaw') && !inv.IsA('Translocator'))
			{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = weap.default.PickupAmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			}
		Killed.Inventory.Destroy();
		}
		

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('TournamentWeapon') )
		{
		TournamentWeapon(Other).DeathMessage= "%o was screwed by %k's %w.";
		}
	if ( Other.IsA('UT_BioRifle') )
		{
		UT_BioRifle(Other).ItemName = "Goo Gun";
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

defaultproperties
{
}
