<?php
header("Content-Type: text/html; charset=utf-8");

/******************************************************************************
 *	IpToCountry v1.5 Masterserver script.
 *	-------------------------------------
 *	[1.2] Non-database version by AnthraX
 *	[1.2] Updated for Daylight Saving Time fix by Rush
 *	[1.3] Updated to new GeoIP Database and retrieval method by AnthraX
 *	[1.4] Bugfix release (short php open tag, php4 support) by sphx
 *	[1.5] Code polish by sphx
 ******************************************************************************
 *	Script syntax:
 *	* Single IP resolving:
 *		+ iptocountry15.php?ip=aaa.bbb.ccc.ddd
 *
 *		-> Return: hh:mm aaa.bbb.ccc.ddd:hostname:COUNTRYNAME_LONG:COUNTRYNAME_SHORT:flagname
 *
 *		+ iptocountry15.php?ip=aaa.bbb.ccc.ddd&playerid=xxx
 *
 *		-> Return: hh:mm xxx:aaa.bbb.ccc.ddd:hostname:COUNTRYNAME_LONG:COUNTRYNAME_SHORT:flagname
 *	* Multi IP resolving:
 *		+ iptocountry15.php?ip=aaa.bbb.ccc.ddd,eee.fff.ggg.hhh,iii.jjj.kkk.lll
 *
 *		-> Return: hh:mm aaa.bbb.ccc.ddd:hostname:COUNTRYNAME_LONG:COUNTRYNAME_SHORT:flagname,eee.fff.ggg.hhh:hostname:COUNTRYNAME_LONG:COUNTRYNAME_SHORT:flagname,iii.jjj.kkk.lll:hostname:COUNTRYNAME_LONG:COUNTRYNAME_SHORT:flagname
 ******************************************************************************/

error_reporting(E_WARNING);

/******************************************************************************
 * (Rush) Support for Daylight Saving Time
 ******************************************************************************/

$timestamp = mktime(gmdate("H, i, s, m, d, Y")); // UTC time
$this_year=gmdate("Y", $timestamp);

// last sunday in march at 1am UTC
$last_day_of_march=gmmktime(1,0,0,3,31,$this_year);
$last_sunday_of_march=strtotime("-".gmdate("w", $last_day_of_march)." day", $last_day_of_march);

// last sunday in october at 1am UTC
$last_day_of_october=gmmktime(1,0,0,10,31,$this_year);
$last_sunday_of_october=strtotime("-".gmdate("w", $last_day_of_october)." day", $last_day_of_october);

if(($timestamp > $last_sunday_of_march) && ($timestamp < $last_sunday_of_october))
{
    $timestamp=$timestamp+3600; // foward one hour
}

$gmt = date("H:i", $timestamp);

/******************************************************************************
 * Request Handling
 ******************************************************************************/

/* This file contains the $countries array ... */
include("ip_files/countries.php");

/* This file contains the parsing functions for the binary database */
include("geoip.inc");

/* Opens the database file */
$gi = geoip_open("GeoIP.dat",GEOIP_STANDARD);

/* Get an array of ips out of query string to process */
if(isset($_GET['ip']))
	$ip = explode(',', $_GET['ip']);
else
	die();

/* (Anth) Resolve the ips one by one. This approach is a bit more elegant than the one in v1.2 */
for($i=0; $i <= 49 && $ip[$i]!= ''; $i++)
{
	$iploc   = geoip_country_code_by_addr($gi,$ip[$i]);
	$Prefix1 = strtolower($iploc);
	$Prefix2 = $countries[$iploc][0];
	$Country = $countries[$iploc][1];

	if(strstr($Country, ','))
		$Country=str_replace(', ', "-", $Country);
	
	/* Handling for single IP requests  -> fixed by sphx */
	$ip_info = $ip[$i].':'.gethostbyaddr($ip[$i]).':'.$Country.':'.$Prefix2.':'.$Prefix1;
	
	if($i == 0)
	{
		echo $gmt.' ';
		if(isset($_GET['playerid']))
			echo $_GET['playerid'].':';
	}
	else
		echo ',';

	echo $ip_info;
}
geoip_close($gi);
?>