//*  Dropper Mutator (c) 2010 MrLoathsome aka Scott Armitage *//
//*  Spawns Actors when players or monsters are killed.      *//
class Drop expands Mutator config(Dropper);

var bool bInit;
var() config int NumItems;
var() config int NumDrops;
var() config int SPNumItems;
var() config int SPNumDrops;
var() config bool bRandMode;
var() config bool bSPRandMode;
var() config bool bSuicideDrop;
var() config bool bMvsMspawn;
var() config bool bAnnounceSP;
var() config bool bRandMSizes;
var() config bool bDebugMode;
var() config float DropFreq;
var() config float SPDropFreq;
var() config float MaxMSize;
var() config float MinMSize;
var() config string DropList[255];
var() config float DLFreq[255];
var() config string DWK[255];
var() config int FRotate[255];
var() config float LSpan[255];
var() config float HMult[255];
var() config string SPDropList[255];
var() config float SPDLFreq[255];
var() config string SPDWK[255];
var() config int SPFRotate[255];
var() config float SPLSpan[255];
var() config float SPHMult[255];

function PostBeginPlay()
{
	if (bInit) return; else bInit = True;
	Super.PostBeginPlay();
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	if (((Killed == Killer) && (!bSuicideDrop)) || ((ScriptedPawn(Killed) != None) && (ScriptedPawn(Killer) != None) && (!bMvsMspawn)))
	{
		if ( NextMutator != None )
			return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);
		return false;
	}
	if ((DropFreq != 0.0) && (ScriptedPawn(Killed) == None) && (FRand() <= DropFreq))
	{
		DropRandItems(Killed);
	} else
	if ((SPDropFreq != 0.0) && (ScriptedPawn(Killed) != None) && (FRand() <= SPDropFreq))
	{
		DropRandItemsSP(Killed);
	}
	return Super.PreventDeath(Killed,Killer, damageType,HitLocation);
}

function bool CheckCollision(Actor A, float DSM, vector newLoc)  // Credit to Feralidragon for help with this function
{
local bool isColliding;
local float CRadius, CHeight;

   CRadius = A.CollisionRadius;
   CHeight = A.CollisionHeight;
   A.SetCollisionSize(A.CollisionRadius * DSM, A.CollisionHeight * DSM);
   isColliding = !A.SetLocation(newLoc);
   A.SetCollisionSize(CRadius, CHeight);
   if (bDebugMode)
   {
       if (isColliding)
          log("Can not grow = "$A$"  DrawScaleMult = "$DSM);
       else
          log("Can grow = "$A$"  DrawScaleMult = "$DSM);
   }
   return isColliding;
}

function DropRandItems(Pawn Victim)
{
	local Vector V;
	local int rv, i, retrycnt;
	local float spawnfreq, F;
	local Actor A;
	local class<Actor> aClass;
	local pawn aV;

	retrycnt = 0;
	for (i=0; i<NumDrops; i++)
		{
			if (retrycnt == 0)
				{ if (bRandMode) { rv = (FRand()*NumItems); } else { rv = i; } }
			if (DLFreq[rv] != 0.0) { spawnfreq = DLFreq[rv]; } else { spawnfreq = 1.0; }
			if (FRand() <= spawnfreq)
			{
				if (retrycnt == 0) aClass = class<Actor>(DynamicLoadObject(DropList[rv], class'Class'));
				if ( aClass != None )
				{
					A = Spawn(aClass,,,Victim.Location+Victim.CollisionRadius*(VRand()*(i+retrycnt+2)));
					if (A != None)
					{
						retrycnt = 0;
						A.RemoteRole = ROLE_SimulatedProxy;
						A.SetPhysics(PHYS_Falling);
						A.bCollideWorld = true;
						if (inventory(A) != None)
						{
							inventory(A).RespawnTime = 0.0;
							inventory(A).NetPriority = 1.4;
							inventory(A).BecomePickup();
							if (pickup(A) != None)
							{
								pickup(A).bCanActivate = True;
								pickup(A).bAutoActivate = False;
							}
							if (FRotate[rv] != 0.0)
								{ A.bBounce=True; inventory(A).bRotatingPickup=True; }
							else
								{ A.bBounce=False; inventory(A).bRotatingPickup=False; }
							if (LSpan[rv] != 0.0)
								{ A.LifeSpan = LSpan[rv]; }
							inventory(A).GotoState('PickUp', 'Dropped');
						}
						if (weapon(A) != None) weapon(A).bWeaponStay = False;
						if (ScriptedPawn(A) != None)
						{
							ScriptedPawn(A).bIsPlayer = False;
							ScriptedPawn(A).bIsBoss = False;
							if (DWK[rv] != "") ScriptedPawn(A).DropWhenKilled = class<Inventory>(DynamicLoadObject(DWK[rv], class'Class'));
							if (bRandMSizes)
							{
								F = FMax(MinMSize, (FRand()*MaxMSize));
								V = A.Location;
								if ((F > 1.0) && (CheckCollision(A, F, V))) { F = FMax(MinMSize, FRand()); }
								A.DrawScale = A.DrawScale * F;
								A.Mass = A.Mass * F;
								if (ScriptedPawn(A).Shadow != None)
									{ ScriptedPawn(A).Shadow.DrawScale = ScriptedPawn(A).Shadow.DrawScale * F; }
								ScriptedPawn(A).Health = ScriptedPawn(A).Health * F;
								A.SetCollisionSize((A.CollisionRadius * F), (A.CollisionHeight * F));
							}
							if (HMult[rv] != 0.0)
								{ ScriptedPawn(A).Health = ScriptedPawn(A).Health * HMult[rv]; }
							ScriptedPawn(A).gotostate('Hunting');
							if (!A.isA('Fly'))
							{
								ScriptedPawn(A).bHateWhenTriggered=True;
								ScriptedPawn(A).Intelligence=BRAINS_Human;
								ScriptedPawn(A).bCanStrafe = True;
								ScriptedPawn(A).CombatStyle = FMin((FRand()+0.50), 1.0);
								foreach VisibleActors( class 'pawn' , aV,, A.Location)
								{
									if ((aV != None)  && (aV != A))
									{
								        	ScriptedPawn(A).Hated = aV;   
								          	ScriptedPawn(A).SetEnemy(aV);
										ScriptedPawn(A).enemy = aV;
										ScriptedPawn(A).gotostate('Attacking');
										if (bDebugMode)
											{ Log("Dropper: " $ A.GetHumanName() $ " attacks " $ aV.GetHumanName()$"  -  "$ScriptedPawn(A).enemy); }
										break;
									}
								}
							}
							if (bAnnounceSP)
							{
								if (bDebugMode)
								{
									BroadcastMessage(A.GetHumanName()$" has spawned."$" Scale = "$F$" DrawScale = "$A.DrawScale$" Health = "$ScriptedPawn(A).Health$" Mass = "$A.Mass);
									log(A.GetHumanName()$" has spawned."$" Scale = "$F$" DrawScale = "$A.DrawScale$" Health = "$ScriptedPawn(A).Health$" Mass = "$A.Mass);
								}
								else
									BroadcastMessage(A.GetHumanName()$" has spawned.");
							}
						}
						if (bDebugMode) log("Spawned Actor = "$A);
					}
					else
					{
						retrycnt++;
						if (bDebugMode) log("Dropper:  Attempt #"$retrycnt$" failed for Class: "$DropList[rv]);
						if (retrycnt < 8) { i--; } else { retrycnt = 0; }
					}
				}
			}
			else { i--; }
		}
}

function DropRandItemsSP(Pawn Victim)
{
	local Vector V;
	local int rv, i, retrycnt;
	local Actor A;
	local float spawnfreq, F;
	local class<Actor> aClass;
	local pawn aV;

	retrycnt = 0;
	for (i=0; i<SPNumDrops; i++)
		{
			if (retrycnt == 0)
				{ if (bSPRandMode) { rv = (FRand()*SPNumItems); } else { rv = i; } }
			if (SPDLFreq[rv] != 0.0) { spawnfreq = SPDLFreq[rv]; } else { spawnfreq = 1.0; }
			if (FRand() <= spawnfreq)
			{
				if (retrycnt == 0) aClass = class<Actor>(DynamicLoadObject(SPDropList[rv], class'Class'));
				if ( aClass != None )
				{
					A = Spawn(aClass,,,Victim.Location+Victim.CollisionRadius*(VRand()*(i+retrycnt+2)));
					if (A != None)
					{
						retrycnt = 0;
						A.RemoteRole = ROLE_SimulatedProxy;
						A.SetPhysics(PHYS_Falling);
						A.bCollideWorld = true;
						if (inventory(A) != None)
						{
							inventory(A).RespawnTime = 0.0;
							inventory(A).NetPriority = 1.4;
							inventory(A).BecomePickup();
							if (pickup(A) != None)
							{
								pickup(A).bCanActivate = True;
								pickup(A).bAutoActivate = False;
							}
							if (SPFRotate[rv] != 0.0)
								{ A.bBounce=True; inventory(A).bRotatingPickup=True; }
							else
								{ A.bBounce=False; inventory(A).bRotatingPickup=False; }
							if (SPLSpan[rv] != 0.0)
								{ A.LifeSpan = SPLSpan[rv]; }
							inventory(A).GotoState('PickUp', 'Dropped');
						}
						if (weapon(A) != None) weapon(A).bWeaponStay = False;
						if (ScriptedPawn(A) != None)
						{
							ScriptedPawn(A).bIsPlayer = False;
							ScriptedPawn(A).bIsBoss = False;
							if (SPDWK[rv] != "") ScriptedPawn(A).DropWhenKilled = class<Inventory>(DynamicLoadObject(SPDWK[rv], class'Class'));
							if (bRandMSizes)
							{
								F = FMax(MinMSize, (FRand()*MaxMSize));
								V = A.Location;
								if ((F > 1.0) && (CheckCollision(A, F, V))) { F = FMax(MinMSize, FRand()); }
								A.DrawScale = A.DrawScale * F;
								A.Mass = A.Mass * F;
								if (ScriptedPawn(A).Shadow != None)
									{ ScriptedPawn(A).Shadow.DrawScale = ScriptedPawn(A).Shadow.DrawScale * F; }
								ScriptedPawn(A).Health = ScriptedPawn(A).Health * F;
								A.SetCollisionSize((A.CollisionRadius * F), (A.CollisionHeight * F));
							}
							if (SPHMult[rv] != 0.0)
								{ ScriptedPawn(A).Health = ScriptedPawn(A).Health * SPHMult[rv]; }
							ScriptedPawn(A).gotostate('Hunting');
							if (!A.isA('Fly'))
							{
								ScriptedPawn(A).bHateWhenTriggered=True;
								ScriptedPawn(A).Intelligence=BRAINS_Human;
								ScriptedPawn(A).bCanStrafe = True;
								ScriptedPawn(A).CombatStyle = FMin((FRand()+0.50), 1.0);
								foreach VisibleActors( class 'pawn' , aV,, A.Location)
								{
									if ((aV != None) && (aV != A))
									{
								        	ScriptedPawn(A).Hated = aV;
								          	ScriptedPawn(A).SetEnemy(aV);
										ScriptedPawn(A).enemy = aV;
										ScriptedPawn(A).gotostate('Attacking');
										if (bDebugMode)
											{ Log("Dropper: " $ A.GetHumanName() $ " attacks " $ aV.GetHumanName()$"  -  "$ScriptedPawn(A).enemy); }
										break;
									}
								}
							}
							if (bAnnounceSP)
							{
								if (bDebugMode)
								{
									BroadcastMessage(A.GetHumanName()$" has spawned."$" Scale = "$F$" DrawScale = "$A.DrawScale$" Health = "$ScriptedPawn(A).Health$" Mass = "$A.Mass);
									log(A.GetHumanName()$" has spawned."$" Scale = "$F$" DrawScale = "$A.DrawScale$" Health = "$ScriptedPawn(A).Health$" Mass = "$A.Mass);
								}
								else
									BroadcastMessage(A.GetHumanName()$" has spawned.");
							}
						}
						if (bDebugMode) log("Spawned Actor (SP) = "$A);
					}
					else
					{
						retrycnt++;
						if (bDebugMode) log("Dropper:  (SP) Attempt #"$retrycnt$" failed for Class: "$SPDropList[rv]);
						if (retrycnt < 8) { i--; } else { retrycnt = 0; }
					}
				}
			}
			else { i--; }
		}
}

defaultproperties
{
     NumItems=2
     NumDrops=1
     SPNumItems=2
     SPNumDrops=1
     bRandMode=True
     bSPRandMode=True
     bSuicideDrop=False
     bMvsMspawn=True
     bAnnounceSP=True
     bRandMSizes=True
     bDebugMode=True
     DropFreq=0.5
     SPDropFreq=0.5
     MaxMSize=1.5
     MinMSize=0.33
     DropList(0)="Unreali.SearchLight"
     DropList(1)="UnrealShare.Seaweed"
     DLFreq(0)=1.0
     DLFreq(1)=1.0
     DWK(0)=""
     DWK(1)=""
     FRotate(0)=0
     FRotate(1)=0
     LSpan(0)=0.0
     LSpan(1)=0.0
     HMult(0)=0.0
     HMult(1)=0.0
     SPDropList(0)="Unreali.SearchLight"
     SPDropList(1)="UnrealShare.Seaweed"
     SPDLFreq(0)=1.0
     SPDLFreq(1)=1.0
     SPDWK(0)=""
     SPDWK(1)=""
     SPFRotate(0)=0
     SPFRotate(1)=0
     SPLSpan(0)=0.0
     SPLSpan(1)=0.0
     SPHMult(0)=0.0
     SPHMult(1)=0.0
}
