//==================================================================================================
// CTF2DOMx.DOM - Play CTF maps with Domination.   3/29/13 - MrLoathsome
//==================================================================================================
class DOM extends Domination;

var int BaseCnt;

function PreBeginPlay()
{
	local NavigationPoint N;
	local Vector L;
	local C2DCP Dcp;
	local int x;

	Super.PreBeginPlay();
	for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
	{
		if ((N.IsA('FlagBase')) && (BaseCnt < 4))
		{
			L = N.Location;
			While ((Dcp == None) && (x < 255))
			{
				Dcp = spawn(class'C2DCP',,,L);
				++x;
				L = L + (x * 10 * VRand());
			}
			if (Dcp != None)
			{
				Dcp.PointName = String(FlagBase(N).Team);
				Domination(Level.Game).ControlPoints[BaseCnt] = Dcp;
				++BaseCnt;
				Dcp = None;
			}
		}
	}
}

function Timer()
{
	local C2DCP CP;
	local int i;
	local float c;
	local PlayerReplicationInfo PRI;

	if ( !bGameEnded )
	{
		c = 0.2;
		if ( TimeLimit > 0 )
		{
			if ( RemainingTime < 0.25 * TimeLimit )
			{
				if ( RemainingTime < 0.1 * TimeLimit )
					c = 0.8;
				else
					c = 0.4;
			}
		}

		if ( !bRequireReady || (CountDown <= 0) )
			for (i=0; i<BaseCnt; i++)
			{
				CP = C2DCP(Domination(Level.Game).ControlPoints[i]);
				if ( (CP != None) && (CP.ControllingTeam != None) && CP.bScoreReady )
				{
					CP.ControllingTeam.Score += c;
					CP.Controller.PlayerReplicationInfo.Score += c;
				}
			}

		DomScoreEvent++;
		if (DomScoreEvent >= 5)
		{
			DomScoreEvent = 0;
			for (i=0; i<4; i++)
			{
				if (Teams[i].Score > 0)
				{
					if (Level.Game.WorldLog != None)
						Level.Game.WorldLog.LogSpecialEvent("dom_score_update", i, Teams[i].Score);
					if (Level.Game.LocalLog != None)
						Level.Game.LocalLog.LogSpecialEvent("dom_score_update", i, Teams[i].Score);
				}
			}
			for (i=0; i<32; i++)
			{
				PRI = GameReplicationInfo.PRIArray[i];
				if (PRI != None)
				{
					if (Level.Game.WorldLog != None)
						Level.Game.WorldLog.LogSpecialEvent("dom_playerscore_update", PRI.PlayerID, int(PRI.Score));
					if (Level.Game.LocalLog != None)
						Level.Game.LocalLog.LogSpecialEvent("dom_playerscore_update", PRI.PlayerID, int(PRI.Score));				
				}
			}
		}
		if ( GoalTeamScore > 0 )
			for ( i=0; i<4; i++ )
				if ( Teams[i].Score >= GoalTeamScore )
					EndGame("teamscorelimit");
	}

	Super.Timer();
}

function ClearControl(Pawn Other)
{
	local C2DCP CP;
	local Pawn P, Pick;
	local int Num, i;

	// find a teammate
	if ( !Other.bIsPlayer || (Other.PlayerReplicationInfo.Team == 255) )
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && (P != Other) && (P.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) )
		{
			Num++;
			if ( (Pick == None) || (Rand(Num) == 1) )
				Pick = P;
		}
	for (i=0; i<BaseCnt; i++)
	{
		CP = C2DCP(Domination(Level.Game).ControlPoints[i]);
		if (CP.ControllingTeam != None)
		{
			if ( CP.Controller == Other )
			{
				CP.Controller = Pick;
				CP.UpdateStatus();
			}
		}
	}
}

defaultproperties
{
     MapListType=Class'Botpack.CTFMapList'
     MapPrefix="CTF"
     BeaconName="CTF"
     bSpawnInTeamArea="False"
}
