/*
    IpToCountry 1.1
    Copyright (C) 2005 [es]Rush

    This program is free software; you can redistribute and/or modify
    it under the terms of the Open Unreal Mod License version 1.1.
*/

class LinkActor extends UBrowserHTTPClient config(IpToCountry);

var config bool bSpawnAddon;
var config string PrimaryQueryServer;
var config string SecondaryQueryServer;
var config int MaxTimeout;

var IpAddr PrimaryServerIpAddr;
var IpAddr SecondaryServerIpAddr;
var string CurrentQueryServer;
var bool bSecondaryQueryServer; // true if Primary has failed

var bool bQueryInProgress;

var string QueryQueue[50];
var int QueryCount;

var config string IPData[256];
var config int index; /* next data will be saved to IPData[index] */

var string QueryString;

var bool bSwitchAtClose;

var int ErrorCount;

var bool bDisabled;

event PreBeginPlay()
{
	Super.PreBeginPlay();
	CurrentQueryServer=PrimaryQueryServer;
	SaveConfig();
	Tag='IpToCountry';
}

function PostBeginPlay()
{
	local Addon Ad;
	if(bSpawnAddon)
	{
		Ad=Level.Spawn(class'Addon');
		Level.Game.BaseMutator.AddMutator(Ad);
		Ad.IpToCountry=self;
	}
	log("+----");
	log("| IpToCountry 1.0 by [es]Rush - Enabled!");
	log("| PrimaryQueryServer  : "$PrimaryQueryServer);
	log("| SecondaryQueryServer: "$SecondaryQueryServer);
	log("+----");
}

function string GetItemName(string IP)
{
	local int i;

	if(bDisabled)
		return "!Disabled";

	IP=FixIpAddr(IP);
	if(IP == "")
		return "!Bad Input";

	i=IpInDatabase(IP);
	if(i!=-1)
		return IPData[i];
	else if(IpInQueue(IP))
		return "!Waiting in queue";
	else if(InStr(QueryString, IP) != -1)
		return "!Resolving now";
	else
	{
		if(QueryQueue[49] != "")
			return "!Queue full";
		else
		{
			AddToQueue(IP);
			SendQueue();
			return "!Added to queue";
		}
	}
}

function HTTPReceivedData (string data)
{
	local string result, temp;
	local int elems, i;

	result = ParseString(data);
	elems = ElementsNum(result, ",");

	Super.SetTimer(0.0, false); // disable the timeout count

	if(InStr(result, "Warning") != -1) // php warning ?
	{
		SwitchQueryServer("IpToCountry: "$CurrentQueryServer$" returned bad data! Switching to alternate.");
		SendQueue();
		return;
	}
	if(elems==1)
	{
		if(ElementsNum(result)!=5  || FixIpAddr(SelElem(result, 1)) == "") // some weird data ?
		{
			SwitchQueryServer("IpToCountry: "$CurrentQueryServer$" returned bad data! Switching to alternate.");
			SendQueue();
			return;
		}
   		SaveIPData(result);
   	}
 	else
 	{
 	 	for(i=1;i<=elems;i++)
 	 	{
 	 		temp=SelElem(result, i, ",");
			if(i==1)
			{
				if(ElementsNum(temp)!=5 || FixIpAddr(SelElem(temp, 1)) == "") // some weird data ?
				{
					SwitchQueryServer("IpToCountry: "$CurrentQueryServer$" returned bad data! Switching to alternate.");
					SendQueue();
					return;
				}
			}
			SaveIPData(temp);
 	 	}
 	}
 	QueryString="";
	bQueryInProgress=False;
	SendQueue();
}

function SwitchQueryServer(optional string LogStr)
{
	if(LogStr != "")
		log(LogStr);
	bQueryInProgress=False;

	if(ErrorCount++ > 20)
		bDisabled=True;

	if(bSecondaryQueryServer)
	{
		CurrentQueryServer=PrimaryQueryServer;
		ServerIpAddr=PrimaryServerIpAddr;
	}
	else
	{
		CurrentQueryServer=SecondaryQueryServer;
		ServerIpAddr=SecondaryServerIpAddr;
	}
	bSecondaryQueryServer=!bSecondaryQueryServer;
}

function SetError(int code)
{
	Super.SetError(code);

	switch(code)
	{
		case -1:
			log("IpToCountry: Error in binding the port while connecting to "$CurrentQueryServer$"!");
			break;
		case -2:
			log("IpToCountry: Error at resolving the host "$CurrentQueryServer$"!");
			break;
		case -3:
			log("IpToCountry: "$CurrentQueryServer$" timed out after "$string(MaxTimeout)$" seconds!");
			break;
		default:
			log("IpToCountry: Got HTTP error with code "$string(code)$" from "$CurrentQueryServer$"!");
	}
	 // sometimes the connection doesn't break immediately, it is probably due to some bug in UBrowserHTTPClient, if it happens we have to wait for it inside event Closed() cause we cannot open the same socket if it is already opened
	if(IsConnected())
		bSwitchAtClose=True;
	else
	{
		SwitchQueryServer("IpToCountry: "$CurrentQueryServer$" failed! Trying the alternate.");
		SendQueue();
	}
}

event Closed()
{
	local string CurrentQueryServer;

	Super.Closed();
	if(bSwitchAtClose)
	{
		bSwitchAtClose=False;
		SwitchQueryServer("IpToCountry: "$CurrentQueryServer$" failed! Trying the alternate.");
		SendQueue();
	}
}

function SendQueue()
{
	local int i;
	local string IP, CurrentQueryServer;
	local bool bNotFirst;

	local string SrcHost, Rest;
	local int SrcPort;

	if(bSecondaryQueryServer)
		CurrentQueryServer=SecondaryQueryServer;
	else
		CurrentQueryServer=PrimaryQueryServer;

	if(bQueryInProgress || (QueryQueue[0] == "" && QueryString == ""))
		return;

	for(i=0;i<50;i++)
	{
		if(QueryQueue[i] == "")
			continue;
		IP=QueryQueue[i];
		if(QueryString=="")
			QueryString=QueryQueue[i];
		else
			QueryString=QueryString$","$QueryQueue[i];
		QueryQueue[i]="";
	}
	if(QueryString == "")
		return;

	SrcHost=SepLeft(CurrentQueryServer, "/");
	SrcPort=int(SepRight(SrcHost, ":"));
	if(SrcPort == 0)
		SrcPort=80;
	SrcHost=SepLeft(SrcHost, ":");
	Rest=SepRight(CurrentQueryServer, "/");

	bQueryInProgress=True;
	Browse(SrcHost,"/"$Rest$"?ip="$QueryString,SrcPort,MaxTimeout);
	//we need to store ip addresses which were got by Resolve() in the Browse()
	if(bSecondaryQueryServer)
	{
		if(SecondaryServerIpAddr.Addr == 0)
			SecondaryServerIpAddr = ServerIpAddr;
	}
	else
	{
		if(PrimaryServerIpAddr.Addr == 0)
			PrimaryServerIpAddr = ServerIpAddr;
	}
}

function AddToQueue(string IP)
{
	local int i;

	if(IpInDatabase(IP) != -1 || InStr(QueryString, IP) != -1)
		return;
	for(i=0;i<50;i++)
	{
		if(QueryQueue[i]!="")
			continue;
		QueryQueue[i] = IP;
		if(!bQueryInProgress)
			SendQueue();
		break;
	}
}

function bool SaveIPData(string SetString)
{
	local int i;

	for(i=0;i<256;i++)
	{
		if(IPData[i] != "")
			continue;
		IPData[i]=SetString;
		SaveConfig();
		return true;
	}
	IPData[index]=SetString;
	index = (index+1) % 256;
	SaveConfig();
}

function int IpInDatabase(string IP)
{
	local int i;
	local string host;

	for(i=0;i<256;i++)
	{
		if(SepLeft(IPData[i]) == IP)
			return i;
	}
	return -1;
}

function bool IpInQueue(string IP)
{
	local int i;
	local string host;

	for(i=0;i<50;i++)
	{
		if(QueryQueue[i] == IP)
			return true;
	}
	return false;
}

/* STRING FUNCTIONS */

// Arguments(Input string, Character separating elements)
static final function int ElementsNum(string Str, optional string Char)
{
	local int count, pos;

	if(Char=="")
		Char=":";

	while(true)
	{
		pos = InStr(Str, Char);
		if(pos == -1)
			break;
		Str=Mid(Str, pos+1);
		count++;
	}
	return count+1;
}

// Arguments(Input string, Element to get, Character separating elements)
static final function string SelElem(string Str, int Elem, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=":";

	while(Elem>1)
	{
		Str=Mid(Str, InStr(Str, Char)+1);
		Elem--;
	}
	pos=InStr(Str, Char);
	if(pos != -1)
    	Str=Left(Str, pos);
    return Str;
}

static final function string SepLeft(string Input, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=":";

	pos = InStr(Input, Char);
	if(pos != -1)
		return Left(Input, pos);
	else
		return Input;
}

static final function string SepRight(string Input, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=":";

	pos = InStr(Input, Char);
	if(pos != -1)
		return Right(Input, len(Input)-pos-1);
	else
		return "";
}

function string ParseString (String Input)
{
	local int CRLF,i;
	local string result, temp;
	local bool b;

	CRLF = InStr(Input ,CR$LF);

	// No CR or LF in string
	if (CRLF == -1)
		return Input;
	else
	{
		result = Right(Input, len(Input)-CRLF-2);
		CRLF = InStr(result ,CR$LF);
		result = Left(result, CRLF);
		return result;
    }
}

function string FixIpAddr(string IP)
{
	local IpAddr Addr;
	local int i;
	local String StrAddr;

	if(!StringToIpAddr(IP, Addr))
		return "";
	StrAddr=IpAddrToString(Addr);
	i = InStr(StrAddr, ":");
	if(i != -1)
		StrAddr = Left(StrAddr, i);
	else
		return "";
	return StrAddr;
}

defaultproperties
{
	bSpawnAddon=True;
	PrimaryQueryServer="utgl.unrealadmin.org/iptocountry-ut.php"
	SecondaryQueryServer="153.19.48.14/iptocountry-ut.php"
	MaxTimeout=10
}