class ActionMut extends Mutator
	Config(ActionMan);

var EventActor EA;

//////////////////////////////////////////////////
// Configuration vars.
//////////////////////////////////////////////////
var config bool bUTDCActive;			// true when UTDC is active.
var config bool bServerCheck;			// Should the server query client.
var config int CheckInterval;			// How often should the server call the client.
var config bool bClientCheck;			// Should client test itself.
var config int ClientCheckInterval;		// How often should the client check itself.
var config bool bMemoryScan;			// true if UTDC should do memory check.
var config bool bProcessCheck;			// true if UTDC should do process check.
var config bool bPackageCheck;			// true if UTDC should do file check.
var config bool bAllowWinampControl;	// true if winamp control is allowed.
var config int SpeedHL;					// value to control how far UT and UTDC measured CPU speed is allowed apart.
var config string DownloadUrl;			// UTDC download URL.
var config string ReconnectUrl;			// Reconnect URL.
var config bool bBanPlayer;				// true if hook cheaters should be banned.
var config bool bKickPlayer;			// true if hook cheaters should be kicked.
var config bool bKickForCorruptMemory;	// true if failed memory check should trigger kick.
var config bool bKickForCorruptFile;	// true if failed file check should trigger kick.
var config bool bKickForHook;			// true if failed process check should kick.
var config bool bKickForTimer;			// true if failed process check should kick.
var config bool bKickForSpeedHack;		// true if failed process check should kick.
var config bool bKickForUBot;			// true if uscript bot cheaters should be kicked.
var config bool bSafeKick;				// true if only identified cheats should trigger kick.
var config bool bExternalLog;			// true if external log should be made.
var config string LogPath;				// External log directory path.
var config string ShotPath;				// Screen shot directory path.
var config bool bOSCare;				// true if mac and linus client should be allowed.
var config bool bForceNativeSpawn;		// true if native actor should always be spawned.
var config bool bShowLogo;				// true if badge should be shown.
var config int LogoXpos;				// horizontal position of logo.
var config int LogoYpos;				// vertical position of logo.
var config string ShotPassword;			// password to do client screenshot.
var config bool bDisableTrace;			// If true trace functions are disabled.
var config bool bDetectTraceCalls;		// If true trace function calls are detected.
var config bool bDisableDraw;			// If true draw functions are disabled.
var config bool bDetectDrawCalls;		// If true draw function calls are detected.
var config string TraceAllowList;
var config string DrawAllowList;
var config string UTDCMD5;

var config bool bAllow440;				// True if UT version 4.40 clients should be allowed.
var config bool bAllow451a;				// True if UT version 4.51a clients should be allowed.
var config bool bAllow451b;				// True if UT version 4.51b clients should be allowed.

// Screen shoot.
var config int SendMode;				// send mode.
var config int ImageServerPort;			// screenshot server port.
var config string ImageServerIp;		// screenshot server ip.
var config int ConnectionTimeout;		// connection timeout.
var config int JpgQuality;				// picture quality.

// Package check.
const MAXFILESTOCHECK	= 8;
var config string Package[8];			// user defined files to check.
var config string MD5[8];				// user defined file hashes.

const VersionStr		= "ACTIONMAN v.1.1";

const SFREQMIN			= 4;
const SFREQMAX			= 50;
const CFREQMIN			= 3;
const CFREQMAX			= 30;
const CONNTIMEOUTMIN	= 2;
const CONNTIMEOUTMAX	= 20;
const JPGQUALITYMIN		= 40;
const JPGQUALITYMAX		= 100;

event PostBeginPlay()
{
	EA = Spawn(Class'EventActor', self);
	EA.MyMut = self;
	EA.Init();
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local private string strCapped;
	local private string AllowedVersions;

	Super.Mutate(MutateString, Sender);
	strCapped = Caps(MutateString);

	// Client commands.
	if (strCapped == "ACTIONMAN COMMANDS")
	{
		Sender.ClientMessage("********** " $ VersionStr $ " Commands **********");

		if (Sender.bAdmin == true && Sender.PlayerReplicationInfo.bAdmin == true)
		{
			Sender.ClientMessage("mutate actionman set utdc on/off");
			Sender.ClientMessage("mutate actionman set clientcheck on/off");
			Sender.ClientMessage("mutate actionman set cfrequency <value from "$CFREQMIN$" to "$CFREQMAX$">");
			Sender.ClientMessage("mutate actionman set servercheck on/off");
			Sender.ClientMessage("mutate actionman set sfrequency <value from "$SFREQMIN$" to "$SFREQMAX$">");
			Sender.ClientMessage("mutate actionman set packagecheck on/off");
			Sender.ClientMessage("mutate actionman set processcheck on/off");
			Sender.ClientMessage("mutate actionman set memoryscan on/off");
			Sender.ClientMessage("mutate actionman set detecttrace on/off");
			Sender.ClientMessage("mutate actionman set disabletrace on/off");
			Sender.ClientMessage("mutate actionman set detectdraw on/off");
			Sender.ClientMessage("mutate actionman set disabledraw on/off");
			Sender.ClientMessage("mutate actionman set learnallowfunctions");
			Sender.ClientMessage("mutate actionman set winampcontrol on/off");
			Sender.ClientMessage("mutate actionman set allow all os on/off");
			Sender.ClientMessage("mutate actionman set kick on/off");
			Sender.ClientMessage("mutate actionman set safekick on/off");
			Sender.ClientMessage("mutate actionman set memoryscan kick on/off");
			Sender.ClientMessage("mutate actionman set packagecheck kick on/off");
			Sender.ClientMessage("mutate actionman set timer kick on/off");
			Sender.ClientMessage("mutate actionman set speedhack kick on/off");
			Sender.ClientMessage("mutate actionman set ubot kick on/off");
			Sender.ClientMessage("mutate actionman set ban on/off");
			Sender.ClientMessage("mutate actionman set allow440 on/off");
			Sender.ClientMessage("mutate actionman set allow451a on/off");
			Sender.ClientMessage("mutate actionman set allow451b on/off");
			Sender.ClientMessage("mutate actionman set forcenativespawn on/off");
			Sender.ClientMessage("mutate actionman set showlogo on/off");
			Sender.ClientMessage("mutate actionman set logoxpos <value from 0 to 90>");
			Sender.ClientMessage("mutate actionman set logoypos <value from 0 to 90>");
			Sender.ClientMessage("mutate actionman set screenshotwhenlog on/off");
			Sender.ClientMessage("mutate actionman set sendmode <value from 0 to 2>");
			Sender.ClientMessage("mutate actionman set conntimeout <value from "$CONNTIMEOUTMIN$" to "$CONNTIMEOUTMAX$">");
			Sender.ClientMessage("mutate actionman set jpgquality <value from "$JPGQUALITYMIN$" to "$JPGQUALITYMAX$">");
		}
	}
	else if (strCapped == "ACTIONMAN SETTINGS")
	{
		Sender.ClientMessage("********** " $ VersionStr $ " Settings **********");
		Sender.ClientMessage("UTDC is active:"@							bUTDCActive);

		Sender.ClientMessage("Server check:"@							bServerCheck);
		Sender.ClientMessage("Server checkfrequency is done every "@	CheckInterval@"seconds");
		Sender.ClientMessage("Client check:"@							bClientCheck);
		Sender.ClientMessage("Client checkfrequency is done every"@		ClientCheckInterval@"seconds");
		Sender.ClientMessage("Memory check:"@							bMemoryScan);
		Sender.ClientMessage("Package check:"@							bPackageCheck);
		Sender.ClientMessage("Detect draw function calls:"@				bDetectDrawCalls);
		Sender.ClientMessage("Disable draw function calls:"@			bDisableDraw);
		Sender.ClientMessage("Detect trace function calls:"@			bDetectTraceCalls);
		Sender.ClientMessage("Disable trace function calls:"@			bDisableTrace);
		Sender.ClientMessage("Player kick for hook:"@					bKickPlayer);
		Sender.ClientMessage("Player kick for timer:"@					bKickForTimer);
		Sender.ClientMessage("Player kick for speed hack:"@				bKickForSpeedHack);
		Sender.ClientMessage("Player kick for failed MD5 check:"@		bKickForCorruptFile);
		Sender.ClientMessage("Player kick for failed memory check:"@	bKickForCorruptMemory);
		Sender.ClientMessage("Player kick for uscript bot:"@			bKickForUBot);
		Sender.ClientMessage("Player ban:"@								bBanPlayer);
		Sender.ClientMessage("Safe kick:"@								bSafeKick);
		Sender.ClientMessage("Every operating system allowed:"@			bOSCare);
		Sender.ClientMessage("Force native spawn:"@						bForceNativeSpawn);
		Sender.ClientMessage("Winamp control:"@							bAllowWinampControl);

		AllowedVersions = "v4.36";
		if (bAllow440)
			AllowedVersions = AllowedVersions$", v4.40";
		if (bAllow451a)
			AllowedVersions = AllowedVersions$", v4.51a";
		if (bAllow451b)
		 	AllowedVersions = AllowedVersions$" and v4.51b";
		Sender.ClientMessage("Allowed UT versions: " $					AllowedVersions);
	}

	if (Sender.bAdmin == true && Sender.PlayerReplicationInfo.bAdmin == true)
	{
		// Set commands.
		if (Left(strCapped,14) == "ACTIONMAN SET ")
		{
			strCapped = Mid(strCapped,14);

			if (strCapped == "ALLOW ALL OS OFF")
			{
				bOSCare = false;
				Sender.ClientMessage("All OS allowed: " $ bOSCare);
			}
			else if (strCapped == "ALLOW ALL OS ON")
			{
				bOSCare = true;
				Sender.ClientMessage("All OS allowed: " $ bOSCare);
			}
			else if (strCapped == "UTDC ON")
			{
				bUTDCActive = true;
				Sender.ClientMessage("UTDC is active: " $ bUTDCActive);
			}
			else if (strCapped == "UTDC OFF")
			{
				bUTDCActive = false;
				Sender.ClientMessage("UTDC is active: " $ bUTDCActive);
			}
			else if (strCapped == "SERVERCHECK ON")
			{
				bServerCheck = true;
				Sender.ClientMessage("Server check is active: " $ bServerCheck);
			}
			else if (strCapped == "SERVERCHECK OFF")
			{
				bServerCheck = false;
				Sender.ClientMessage("Server check is active: " $ bServerCheck);
			}
			else if (strCapped == "CLIENTCHECK ON")
			{
				bClientCheck = true;
				Sender.ClientMessage("Client check is active: " $ bClientCheck);
			}
			else if (strCapped == "CLIENTCHECK OFF")
			{
				bClientCheck = false;
				Sender.ClientMessage("Client check is active: " $ bClientCheck);
			}
			else if (Left(strCapped,11) == "SFREQUENCY ")
			{
				strCapped = Mid(strCapped,11);
				CheckInterval = Clamp(INT(strCapped), SFREQMIN, SFREQMAX);
				Sender.ClientMessage("Server checkfrequency is set to every " $ CheckInterval $ " seconds");
			}
			else if (Left(strCapped,11) == "CFREQUENCY ")
			{
				strCapped = Mid(strCapped,11);
				ClientCheckInterval = Clamp(INT(strCapped), CFREQMIN, CFREQMAX);
				Sender.ClientMessage("Client checkfrequency is set to every " $ ClientCheckInterval $ " seconds");
			}
			else if (strCapped == "BAN ON")
			{
				bBanPlayer = true;
				Sender.ClientMessage("Player ban is active: " $ bBanPlayer);
			}
			else if (strCapped == "BAN OFF")
			{
				bBanPlayer = false;
				Sender.ClientMessage("Player ban is active: " $ bBanPlayer);
			}
			else if (strCapped == "KICK ON")
			{
				bKickPlayer = true;
				bKickForHook = true;
				Sender.ClientMessage("Player kick is active: " $ bKickPlayer);
			}
			else if (strCapped == "KICK OFF")
			{
				bKickPlayer = false;
				bKickForHook = false;
				Sender.ClientMessage("Player kick is active: " $ bKickPlayer);
			}
			else if (strCapped == "SAFEKICK ON")
			{
				bSafeKick = true;
				Sender.ClientMessage("Save kick is active: " $ bSafeKick);
			}
			else if (strCapped == "SAFEKICK OFF")
			{
				bSafeKick = false;
				Sender.ClientMessage("Save kick is active: " $ bSafeKick);
			}
			else if (strCapped == "ALLOW440 ON")
			{
				bAllow440 = true;
				Sender.ClientMessage("UT version 4.40 allowed: " $ bAllow440);
			}
			else if (strCapped == "ALLOW440 OFF")
			{
				bAllow440 = false;
				Sender.ClientMessage("UT version 4.40 allowed: " $ bAllow440);
			}
			else if (strCapped == "ALLOW451A ON")
			{
				bAllow451a = true;
				Sender.ClientMessage("UT version 4.51a allowed: " $ bAllow451a);
			}
			else if (strCapped == "ALLOW451A OFF")
			{
				bAllow451a = false;
				Sender.ClientMessage("UT version 4.51a allowed: " $ bAllow451a);
			}
			else if (strCapped == "ALLOW451B ON")
			{
				bAllow451b = true;
				Sender.ClientMessage("UT version 4.51b allowed: " $ bAllow451b);
			}
			else if (strCapped == "ALLOW451B OFF")
			{
				bAllow451b = false;
				Sender.ClientMessage("UT version 4.51b allowed: " $ bAllow451b);
			}
			else if (strCapped == "FORCENATIVESPAWN ON")
			{
				bForceNativeSpawn = true;
				Sender.ClientMessage("Force native spawn: " $ bForceNativeSpawn);
			}
			else if (strCapped == "FORCENATIVESPAWN OFF")
			{
				bForceNativeSpawn = false;
				Sender.ClientMessage("Force native spawn: " $ bForceNativeSpawn);
			}
			else if (strCapped == "SHOWLOGO ON")
			{
				bShowLogo = true;
				Sender.ClientMessage("Show logo: " $ bShowLogo);
			}
			else if (strCapped == "SHOWLOGO OFF")
			{
				bShowLogo = false;
				Sender.ClientMessage("Show logo: " $ bShowLogo);
			}
			else if (strCapped == "PACKAGECHECK ON")
			{
				bPackageCheck = true;
				Sender.ClientMessage("Package check: " $ bPackageCheck);
			}
			else if (strCapped == "PACKAGECHECK OFF")
			{
				bPackageCheck = false;
				Sender.ClientMessage("Package check: " $ bPackageCheck);
			}
			else if (strCapped == "PROCESSCHECK ON")
			{
				bProcessCheck = true;
				Sender.ClientMessage("Process check: " $ bProcessCheck);
			}
			else if (strCapped == "PROCESSCHECK OFF")
			{
				bProcessCheck = false;
				Sender.ClientMessage("Process check: " $ bProcessCheck);
			}
			else if (strCapped == "PACKAGECHECK KICK ON")
			{
				bKickForCorruptFile = true;
				Sender.ClientMessage("Package check kick: " $ bKickForCorruptFile);
			}
			else if (strCapped == "PACKAGECHECK KICK OFF")
			{
				bKickForCorruptFile = false;
				Sender.ClientMessage("Package check kick: " $ bKickForCorruptFile);
			}
			else if (strCapped == "MEMORYSCAN ON")
			{
				bMemoryScan = true;
				Sender.ClientMessage("Memory scan: " $ bMemoryScan);
			}
			else if (strCapped == "MEMORYSCAN OFF")
			{
				bMemoryScan = false;
				Sender.ClientMessage("Memory scan: " $ bMemoryScan);
			}
			else if (strCapped == "MEMORYSCAN KICK ON")
			{
				bKickForCorruptMemory = true;
				Sender.ClientMessage("Memory scan kick: " $ bKickForCorruptMemory);
			}
			else if (strCapped == "MEMORYSCAN KICK OFF")
			{
				bKickForCorruptMemory = false;
				Sender.ClientMessage("Memory scan kick: " $ bKickForCorruptMemory);
			}
			else if (strCapped == "TIMER KICK ON")
			{
				bKickForTimer = true;
				Sender.ClientMessage("Timer kick: " $ bKickForTimer);
			}
			else if (strCapped == "TIMER KICK OFF")
			{
				bKickForTimer = false;
				Sender.ClientMessage("Timer kick: " $ bKickForTimer);
			}
			else if (strCapped == "SPEEDHACK KICK ON")
			{
				bKickForSpeedHack = true;
				Sender.ClientMessage("Speed hack kick: " $ bKickForSpeedHack);
			}
			else if (strCapped == "SPEEDHACK KICK OFF")
			{
				bKickForSpeedHack = false;
				Sender.ClientMessage("Speed hack kick: " $ bKickForSpeedHack);
			}
			else if (strCapped == "WINAMPCONTROL ON")
			{
				bAllowWinampControl = true;
				Sender.ClientMessage("Winamp control: " $ bAllowWinampControl);
			}
			else if (strCapped == "WINAMPCONTROL OFF")
			{
				bAllowWinampControl = false;
				Sender.ClientMessage("Winamp control: " $ bAllowWinampControl);
			}
			else if (Left(strCapped, 9) == "LOGOXPOS ")
			{
				strCapped = Mid(strCapped, 9);
				LogoXpos = Clamp(INT(strCapped), 0, 90);
				Sender.ClientMessage("Logo is set to x position"@LogoXpos);
			}
			else if (Left(strCapped, 9) == "LOGOYPOS ")
			{
				strCapped = Mid(strCapped, 9);
				LogoYpos = Clamp(INT(strCapped), 0, 90);
				Sender.ClientMessage("Logo is set to y position"@LogoYpos);
			}
			else if (Left(strCapped, 9) == "SENDMODE ")
			{
				strCapped = Mid(strCapped, 9);
				SendMode = Clamp(INT(strCapped), 0, 2);
				Sender.ClientMessage("Screenshot mode is set to:"@SendMode);
			}
			else if (Left(strCapped, 12) == "CONNTIMEOUT ")
			{
				strCapped = Mid(strCapped, 12);
				ConnectionTimeout = Clamp(INT(strCapped), CONNTIMEOUTMIN, CONNTIMEOUTMAX);
				Sender.ClientMessage("Screenshot connection timeout is set to:"@ConnectionTimeout);
			}
			else if (Left(strCapped, 11) == "JPGQUALITY ")
			{
				strCapped = Mid(strCapped, 11);
				JpgQuality = Clamp(INT(strCapped), JPGQUALITYMIN, JPGQUALITYMAX);
				Sender.ClientMessage("Screenshot quality is set to:"@JpgQuality);
			}
			else if (strCapped == "DETECTTRACE ON")
			{
				bDetectTraceCalls = true;
				Sender.ClientMessage("Detect trace calls: " $ bDetectTraceCalls);
			}
			else if (strCapped == "DETECTTRACE OFF")
			{
				bDetectTraceCalls = false;
				Sender.ClientMessage("Detect trace calls: " $ bDetectTraceCalls);
			}
			else if (strCapped == "DISABLETRACE ON")
			{
				bDisableTrace = true;
				Sender.ClientMessage("Disable trace functions: " $ bDisableTrace);
			}
			else if (strCapped == "DISABLETRACE OFF")
			{
				bDisableTrace = false;
				Sender.ClientMessage("Disable trace functions: " $ bDisableTrace);
			}
			else if (strCapped == "DETECTDRAW ON")
			{
				bDetectDrawCalls = true;
				Sender.ClientMessage("Detect draw calls: " $ bDetectDrawCalls);
			}
			else if (strCapped == "DETECTDRAW OFF")
			{
				bDetectDrawCalls = false;
				Sender.ClientMessage("Detect draw calls: " $ bDetectDrawCalls);
			}
			else if (strCapped == "DISABLEDRAW ON")
			{
				bDisableDraw = true;
				Sender.ClientMessage("Disable draw functions: " $ bDisableDraw);
			}
			else if (strCapped == "DISABLEDRAW OFF")
			{
				bDisableDraw = false;
				Sender.ClientMessage("Disable draw functions: " $ bDisableDraw);
			}
			else if (strCapped == "LEARNALLOWFUNCTIONS")
			{
				Sender.ClientMessage("Learning ufunctions to allow.");
				EA.DCMut.LearnAllowedFunctions();
			}
			else if (strCapped == "UBOT KICK ON")
			{
				bKickForUBot = true;
				Sender.ClientMessage("UBot kick: " $ bKickForUBot);
			}
			else if (strCapped == "UBOT KICK OFF")
			{
				bKickForUBot = false;
				Sender.ClientMessage("UBot kick: " $ bKickForUBot);
			}

			SaveConfig();
		}
	}
}

defaultproperties
{
	bUTDCActive=True
	bPackageCheck=True
	bServerCheck=True
	CheckInterval=12
	bClientCheck=True
	ClientCheckInterval=7
	bMemoryScan=True
	bProcessCheck=True
	bAllowWinampControl=True
	SpeedHL=199
	bBanPlayer=False
	bKickPlayer=True
	bKickForCorruptMemory=True
	bKickForHook=True
	bKickForTimer=True
	bKickForSpeedHack=False
	bKickForCorruptFile=True
	bKickForUBot=False
	bSafeKick=False
	bExternalLog=True
	LogPath="../Logs/"
	ShotPath="../Logs/"
	bOSCare=True
	bForceNativeSpawn=False
	DownloadUrl="None"
	ReconnectUrl="None";
	bShowLogo=True
	LogoYpos=10
	LogoXpos=1
	bAllow440=True
	bAllow451a=True
	bAllow451b=True
	UTDCMD5=""
	SendMode=0
	ImageServerPort=8000
	ImageServerIp="192.168.0.2"
	ConnectionTimeout=5
	JpgQuality=50
	ShotPassword=""	
	bDisableTrace=False
	bDetectTraceCalls=False
	bDisableDraw=False
	bDetectDrawCalls=False
	TraceAllowList=""
	DrawAllowList=""
}
