class UTDCCommon extends ReplicationInfo;

// Version strings.
const UT436		= "v.4.36";			// UT 4.36 version string.
const UT440		= "v.4.40";			// UT 4.40 version string.
const UT451a	= "v.4.51a";		// UT 4.51a version string.
const UT451b	= "v.4.51b";		// UT 4.51b version string.
const TOPS		= "Tactical Ops";	// Tactical ops string.

var bool	bClientReplied;		// True when client have replied.

// Time out variables
var int		TryCountLimit;		// Number of times to call check before timeout.
var int		UpdateInterval;		// Time between checks.
var int		TryCount;			// Number of times check have been called without success.
var name	CallbackState;		// State to call back to do check.

//--------------------------------------------------------------------------------

replication
{
	// Functions the Server calls on the Client.
	reliable if (ROLE == ROLE_Authority)
		OpenConsole;
}

//-------------------------------------------------------------------------------

simulated function OpenConsole()
{
	local private WindowConsole Con;

	Con = WindowConsole(PlayerPawn(Owner).Player.Console);

    if (Con == None)
    {
		Log("No Console", 'UTDC');
		return;
    }

    if (!Con.bCreatedRoot || Con.Root==None)
    {
        // Tell the console to create the root.
		Con.CreateRootWindow(None);
    }

    // Hide the status and menu bars and all other windows, so that our window alone will show.
    Con.bQuickKeyEnable = true;
    Con.LaunchUWindow();

	Con.ShowConsole();
}


// ==================================================================================
// Wait state
// ==================================================================================
function WaitForClientReply(int TryCountLimit, int UpdateInterval, name CallbackState)
{
	if (self.CallbackState != CallbackState)
	{
		// Set global variables.
		self.TryCountLimit = TryCountLimit;
		self.UpdateInterval = UpdateInterval;
		self.CallbackState = CallbackState;

		TryCount = 0;
	}
	bClientReplied = false;
	GotoState('WaitForCReply');
}

// Overridden.
function ClientTimeOut();

state WaitForCReply
{
	function Timer()
	{
		if (bClientReplied)
		{
			TryCount = 0;
			GotoState(CallbackState);
		}
		else
		{
			TryCount++;
			if (TryCount > TryCountLimit)
			{
				ClientTimeOut();
			}
			GotoState(CallbackState);
		}
	}

	Begin:
		SetTimer(UpdateInterval, false);
}

// ==================================================================================
// Misc. functions.
// ==================================================================================

function string IntToHex(int i)
{
  const hex = "0123456789ABCDEF";
  
  return Mid(hex, i >> 28 & 0xf, 1) $ Mid(hex, i >> 24 & 0xf, 1)
      $ Mid(hex, i >> 20 & 0xf, 1) $ Mid(hex, i >> 16 & 0xf, 1)
      $ Mid(hex, i >> 12 & 0xf, 1) $ Mid(hex, i >> 8 & 0xf, 1)
      $ Mid(hex, i >> 4 & 0xf, 1) $ Mid(hex, i & 0xf, 1);
}

function string GetTwoDigitNumber(coerce string S)
{
	return PrePad(S, "0", 2);
}

function string PrePad(coerce string S, string Pad, int Count)
{
	while (Len(S) < Count)
		S = Pad $ S;
	return S;
}

function string PostPad(coerce string S, string Pad, int Count)
{
	while (Len(S) < Count)
		S = S $ Pad;
	return S;
}

function string GetDateString()
{
	return GetTwoDigitNumber(Level.Day) $"-"$ GetTwoDigitNumber(Level.Month) $"-"$ GetTwoDigitNumber(Level.Year) @"/"@ 
		GetTwoDigitNumber(Level.Hour) $":"$ GetTwoDigitNumber(Level.Minute) $":"$ GetTwoDigitNumber(Level.Second);
}

function string GetIpAdress(PlayerPawn Player)
{
	local private string IpAddress;
	IpAddress = Player.GetPlayerNetworkAddress();
	IpAddress = Left(IpAddress, InStr(IpAddress, ":"));
	return IpAddress;
}

function string GetPlayerName(PlayerPawn Player)
{
	return Player.PlayerReplicationInfo.PlayerName;
}
