class IUTDCEvent extends Actor;

var IUTDC DCMut;

// List of check types.
enum CheckType
{
	Request,
	Initial,
	ExtraInfo
};

function bool FindUTDC()
{
	local private IUTDC UTDC;

	if (DCMut != None)
		return true;

	foreach AllActors(Class'IUTDC', UTDC, 'UTDC')
	{
		DCMut = UTDC;
		return true;
	}
	return false;
}

function StartUTDC()
{
	DCMut.bInitialized = true;
}

function UTDCLog(coerce string Msg, bool bExternal, optional PlayerPawn Player, optional bool bAdminNotice)
{
	DCMut.UTDCLog(Msg, bExternal, Player, bAdminNotice);
}

function BanPlayer(PlayerPawn Player)
{
	DCMut.BanPlayer(Player);
}

//////////////////////////////////////////////////
// Events.
//////////////////////////////////////////////////

// Screen shot events.

// Screen shot started,
function ScreenShotStarted(PlayerPawn Player,  out string FilePath, out string FileName);

// Screen shot finished.
function ScreenShotFinished(PlayerPawn Player, string FileName);

// Screen shot is already being sent from client.
function ScreenShotAlreadySending(PlayerPawn Player, string FileName);

// Screen shot timeout.
function ScreenShotTimeout(PlayerPawn Player);


// Player state events.

// Player got no dll file installed.
function PlayerGotNoDll(PlayerPawn Player);

// Player joined.
function bool PlayerJoin(PlayerPawn Player, string OS, bool bIsChecked);

// Player initialized and finished initial check.
function PlayerInitialized(PlayerPawn Player, IUTDCCheck Check);

// Unknown function  caller.
function UnknownFunctionCaller(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee);

// Cheat detected events.

// Player failed the memory check.
function PlayerFailedMemoryCheck(PlayerPawn Player, IUTDCCheck Check, int LogType, string Addrs, string Hash);

// Server / Client check.
function PlayerFailedCheck(PlayerPawn Player, IUTDCCheck Check, string ServerReceived, string AlteredInfo, string ProcessNames, string AlteredId, string ExtraInfo, string HookMatch);

// Player failed file check.
function PlayerFailedFileCheck(PlayerPawn Player, IUTDCCheck Check, int FileIndex, string Hash);

// Player failed process check.
function PlayerFailedProcessCheck(PlayerPawn Player, IUTDCCheck Check, bool bTimer, bool bSpeedHack, bool bHook, string CheatTrace);

// Illegal UFunction call detected.
function IllegalUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string IllegalCallerClass);

// Illegal UFunction call detected.
function LearnedUFunctionCall(PlayerPawn Player, IUTDCCheck Check, string IllegalFuncCaller, string IllegalFuncCallee, string DrawAllowList, string TraceAllowList);
