// =========================================================================== 
// Project: TickFix by TNSe (tnse@online.no)
// 
// Description: 
// This file contains code for TickFix DLL.
// =========================================================================== 

//#include "mmsystem.h"

#include "TFPrivate.h"

IMPLEMENT_PACKAGE(TF);

IMPLEMENT_CLASS(ATickFix); 

IMPLEMENT_FUNCTION (ATickFix, 666, execFixTick);

// execIncTest - called as IncTest method in UnrealScript 
void ATickFix::execFixTick (FFrame& Stack, RESULT_DECL)
{
    // input parameter handling 
    guard (TickFix::execFixTick);
    P_FINISH;
	
	TIMECAPS TC;
	UINT NewRes;

	if (timeGetDevCaps(&TC,sizeof(TIMECAPS)) == TIMERR_NOERROR)
		GLog->Logf(TEXT("TickFix -> Timer Resolution, Min %i - Max %i"),TC.wPeriodMin,TC.wPeriodMax);
	else
		GLog->Logf(TEXT("TickFix -> Failed to retreive Capabilities of Timer!"));
	
	NewRes = TC.wPeriodMin;
	if (NewRes > 1)
		GLog->Logf(TEXT("TickFix -> WARNING, this computer may NOT be suitable for a good UT Server!"));

    GLog->Logf( TEXT("TickFix -> Setting Timer to %ims"), NewRes); 

	if (timeBeginPeriod(NewRes) == TIMERR_NOERROR)
		GLog->Logf(TEXT("TickFix -> Timer Set successfully!"));
	else
		GLog->Logf(TEXT("TickFix -> Failed to set Timer!"));

    unguardexec; 
} 

// Destroy never gets called properly on map changes, so this never gets called...

IMPLEMENT_FUNCTION (ATickFix, 667, execUnfixTick);

// execIncTest - called as IncTest method in UnrealScript 
void ATickFix::execUnfixTick (FFrame& Stack, RESULT_DECL)
{
    // input parameter handling 
    guard (TickFix::execUnfixTick); 
    P_FINISH;

    GLog->Logf( TEXT("TickFix -> Unsetting Timer.") ); 

	//timeEndPeriod(1);

    unguardexec; 
} 
