class FastSwitchDetect expands Mutator
	config( FastSwitchDetect );

const VERSION = "20080103";

// Ini settings
var config bool bBroadcast;
var config bool bNoDistanceCheck;
var config bool bSimulation; // Simulation mode: no kick
var config float timeThreshhold; // Adjustable so admin can tweak this value

// Internal class variables
var bool bInitialized;

var private float deltaTime[32], lastDistance[32]; // PID shouldn't be used but nevermind
var private Pawn lastVictim[32];

function PreBeginPlay()
{
	// Necessary to get round a bug that causes PreBeginPlay() to get called twice
	if ( !bInitialized )
    {
        bInitialized = true;
        log("Starting FastTurnDetect (Beta)",'FastSwitchDetect');
        log("Please contact the author to submit bugs and suggestions",'FastSwitchDetect');
    }

	// Save ini settings and create ini file
	SaveConfig();

	// So MutatorTakeDamage has an effect
	Level.Game.RegisterDamageMutator( self );
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType )
{
	local int playerID;
	local float levelTime;
	local string playername, playerIP;
	local float currentDistance;

	Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );

	// No point in executing the rest if these two are null
	if( InstigatedBy == none )
		return;

	if( Victim == none )
		return;

    if ( InstigatedBy.IsA('PlayerPawn') )
    {
    	if ( /* !InstigatedBy.PlayerReplicationInfo.bIsABot && */ !InstigatedBy.PlayerReplicationInfo.bIsSpectator )
        {
			playerID = InstigatedBy.PlayerReplicationInfo.PlayerID; // Initialize id to store some values

			levelTime = Level.TimeSeconds;

			deltaTime[ playerID ] = levelTime - deltaTime[ playerID ];
			currentDistance = VSize( InstigatedBy.Location - Victim.Location );

			// Warning: Does not account for simultaneous damage
			if( Victim != lastVictim[ playerID ] && lastVictim[ playerID ] != none ) // Change of victim
				if( bNoDistanceCheck || ( !bNoDistanceCheck && currentDistance < lastDistance[ playerID ] ) )// Current victim is the closest
					if( deltaTime[ playerID ] < timeThreshhold ) // Check if delta time is below threshhold
					{
						// log("Delta time inferior to threshhold limit");

						playerName = InstigatedBy.PlayerReplicationInfo.PlayerName;
						playerIP = PlayerPawn( InstigatedBy ).GetPlayerNetworkAddress();

						if( playerIP == "" );
							playerIP = "0.0.0.0:0";

						log( playerName @ "(IP=" $ playerIP $ ")" @ "DeltaTime=" $ deltaTime[ playerID ] $ "Distances=" @ currentDistance $"/"$ lastDistance[ playerID ],'FastSwitchDetect');

						if( !bSimulation )
						{
							InstigatedBy.Destroy();
							log( playerName @ "was kicked off the server" );
						}

						if( bBroadcast )
							BroadcastMessage( "[FSD]" @ playerName @ "[ IP=" $ playerIP $ "]" @ "was kicked off the server" );
					}

			lastVictim[ playerID ] = Victim;
			lastDistance[ playerID ] = currentDistance;
        }
	}
}

defaultproperties
{
	bBroadcast=false
	bNoDistanceCheck=true
	bSimulation=true
	timeThreshhold=10
}
