class CreateHostDB extends Mutator config(DPD_HostDatabase);

var Actor IpToCountry;
var bool bSaved;

struct Data
{
var string Host;
var string Country;
var string IP;
var string Players;
var string LastSeen;
};

var config Data DB[20000];
var Data temp[128];

function PostBeginPlay()
{
local int i;

	for ( i=0; i<128; i++ )
		{
		temp[i].Host = "";
		temp[i].Country = "";
		temp[i].IP = "";
		temp[i].Players = "";
		temp[i].LastSeen = "";
		}

	BindIpToCountry();

	SetTimer(5.0,True);
}

function bool BindIpToCountry()
{
	local Actor A;
	foreach AllActors(class'Actor', A, 'LinkActor')
		IpToCountry = A;
}

function string GetIpInfo(string IP)
{
	if(IpToCountry != None)
		return IpToCountry.GetItemName(IP);
}

function bool HandleEndGame()
{
local Pawn P;

	Super.HandleEndGame();

	if (!bSaved)
		{
		UpdateDB();
		SaveConfig();
		}
	bSaved = True;

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function UpdateDB()
{
local int i, ii;

	for ( i=0; i<128; i++ )
		{
		if ( temp[i].Host != "" )
			{
			for ( ii=0; ii<20000; ii++ )
				{
				if ( DB[ii].Host == temp[i].Host || DB[ii].Host == "" )
					{
					if ( DB[ii].Players == "" )
						{
						DB[ii].Host = temp[i].Host;
						DB[ii].Country = temp[i].Country;
						DB[ii].IP = temp[i].IP;
						DB[ii].Players = temp[i].Players;
						DB[ii].LastSeen = temp[i].LastSeen;
						ii = 50000;
						}
					else
						{
						DB[ii].Host = temp[i].Host;
						if( InStr(DB[ii].Players, temp[i].Players) == -1)
							DB[ii].Players = DB[ii].Players$","$temp[i].Players;
						ii = 50000;
						}
					}
				}
			}
		}

}

function Timer()
{
local Pawn P;
local string IP;
local String Country,Old;
local int i;
local string AbsoluteTime;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			IP = PlayerPawn(P).GetPlayerNetworkAddress();
			IP = Left(IP, InStr(IP, ":"));
			Country = GetIpInfo(IP);
			if ( Left(Country, 1) != "!" && Left(Country, 1) != "" )
				{
				for ( i=0; i<128; i++ )
					{
					if ( temp[i].Players == "" || temp[i].Players == P.PlayerReplicationInfo.PlayerName )
						{
						//temp array found for player
						temp[i].Players = P.PlayerReplicationInfo.PlayerName;
						//Old = Country;
						temp[i].Host = SelElem(Country,2);
						//Country = Old;
						temp[i].Country = SelElem(Country,3);
						//Country = Old;
						temp[i].IP = SelElem(Country,1);
						AbsoluteTime = string(Level.Year);
						if (Level.Month < 10)
							AbsoluteTime = AbsoluteTime$"/0"$Level.Month;
						else
							AbsoluteTime = AbsoluteTime$"/"$Level.Month;
						if (Level.Day < 10)
							AbsoluteTime = AbsoluteTime$"/0"$Level.Day;
						else
							AbsoluteTime = AbsoluteTime$"/"$Level.Day;
						temp[i].LastSeen = AbsoluteTime;
						i = 500;
						}
					}
				}
			}
		}
}

function string SelElem(string Str, int Elem, optional string Char)
{
local int pos;
	if(Char=="")
		Char=":";

	while(Elem>1)
		{
		Str=Mid(Str, InStr(Str, Char)+1);
		Elem--;
		}
	pos=InStr(Str, Char);
	if(pos != -1)
    		Str=Left(Str, pos);
    	return Str;
}

defaultproperties
{
bSaved=False
}



















