class CreateACEDB extends Mutator config(DPD_ACEDatabase);

var config int		DelaySeconds,
			SecondsBetweenChecks;
var config bool bKickForTunnel;
var Actor IpToCountry;
var bool bSaved;
var int Num,NumTemp;

struct Data
{
var string HWID;
var string IP;
var string Players;
var string RealIP;
var string LastSeen;
};

var config string BanHWID[128];
var config Data DB[20000];
var Data temp[128];

function UpdateDB()
{
local int i,ii;

	for ( i=0; i<128; i++ )
		{
		if ( temp[i].HWID != "" )
			{
			for ( ii=0; ii<20000; ii++ )
				{
				if ( temp[i].HWID == DB[ii].HWID || DB[ii].HWID == "" )
					{
					DB[ii].HWID = temp[i].HWID;
					DB[ii].IP = temp[i].IP;
					if ( DB[ii].Players == "" )
						DB[ii].Players = temp[i].Players;
					else
						{
						if( InStr(DB[ii].Players, temp[i].Players) == -1)
							{
							DB[ii].Players = DB[ii].Players$", "$temp[i].Players;
							}
						}
					DB[ii].RealIP = temp[i].RealIP;
					DB[ii].LastSeen = temp[i].LastSeen;
					ii=50000;
					}
				}
			}
		}
}

function Tick(float DeltaTime)
{
local Pawn P;

	Super.Tick(DeltaTime);

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			if ( P.PlayerReplicationInfo.PlayerName == Temp[NumTemp].Players )
				{
				if ( BanHWID[Num] != "" && Temp[NumTemp].HWID == BanHWID[Num] )
					{
					log("DPD ACE plugin:"@P.PlayerReplicationInfo.PlayerName$" was kicked because his HWID was added to the banlist.");
					P.Destroy();
					Temp[NumTemp].HWID = "";
					}
				//Begin -This is for kick for tunnel (edited by iloveut99)
				else if( bKickForTunnel && Temp[NumTemp].RealIP != Temp[NumTemp].IP && Temp[NumTemp].RealIP!="" && Temp[NumTemp].IP!=""){
					log("DPD ACE plugin:"@P.PlayerReplicationInfo.PlayerName$" was kicked because an UDP Proxy/Tunnel was been detected.");
					p.ClientMessage("===================================================================");
					p.ClientMessage("You have been kicked because an UDP Proxy/Tunnel has been detected.");
					p.ClientMessage("If you think this is an error try contact the admin.");
					p.ClientMessage("===================================================================");
					P.Destroy();
					Temp[NumTemp].RealIP ="";
					Temp[NumTemp].IP ="";
					Temp[NumTemp].HWID = "";
					}
				//End
				}
			}
		}
	NumTemp++;
	If ( NumTemp >= 128 || Temp[NumTemp].Players == "" )
		NumTemp = 0;
	Num++;
	If ( Num >= 128 || BanHWID[Num] == "" )
		Num = 0;
}

function PostBeginPlay()
{
local int i;

	for ( i=0; i<128; i++ )
		{
		temp[i].HWID = "";
		temp[i].IP = "";
		temp[i].Players = "";
		temp[i].RealIP = "";
		temp[i].LastSeen = "";
		}

	SetTimer(DelaySeconds,True);
}

function bool HandleEndGame()
{
	Super.HandleEndGame();

	if (!bSaved)
		{
		UpdateDB();
		bSaved = True;
		SaveConfig();
		}

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function Timer()
{
local Actor ACE;
local int i;

	SetTimer(SecondsBetweenChecks,True);

	ForEach AllActors(class'Actor', ACE)
		{
		if ( ACE.IsA('IACECheck') )
			{
			if ( IACECheck(ACE).PlayerName != "" )
				{
				for ( i=0; i<128; i++ )
					{
					if ( IACECheck(ACE).PlayerName == temp[i].Players || temp[i].Players == "" )
						{
						temp[i].HWID = IACECheck(ACE).HWHash;
						temp[i].IP = IACECheck(ACE).PlayerIP;
						temp[i].Players = IACECheck(ACE).PlayerName;
						temp[i].RealIP = IACECheck(ACE).RealIP;
						temp[i].LastSeen = LastSeen();
						i = 1000;
						}
					}
				}
			}
		}
}

function string LastSeen()
{
local string AbsoluteTime;

	AbsoluteTime = string(Level.Year);

	if (Level.Month < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Month;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Month;

	if (Level.Day < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Day;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Day;

	if (Level.Hour < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Hour;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Hour;

	if (Level.Minute < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Minute;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Minute;

	if (Level.Second < 10)
		AbsoluteTime = AbsoluteTime$".0"$Level.Second;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Second;

	return AbsoluteTime;
}

defaultproperties:
{
DelaySeconds=20
SecondsBetweenChecks=5
bSaved=False
bKickForTunnel=False
}










