//=============================================================================
// HackProtection.
//
// This class defines the mutator that makes up the client-side of CSHP.
//
// (c) 2001, Midnight Interactive
//=============================================================================

class HackProtection expands Mutator;

// ----------------------------------------------------

var string StrTab[255];
var string zzDECSTRTAB[255];
var string encoding_table[64];  
var int    zzKeyNdx;  

// These vars are read from the ini file.  Some are replicated to the client.

var() localized int SecurityLevel;		// The default current security level
var() localized float SecurityFrequency;	// How often should the server call the client
var() localized float SecurityTolerance;	// How long before the client is overdue (in secs)
var() localized int TrackFOV;			// Track the FOV cheats [0 = no, 1 = strict, 2 = loose]
var() localized int Advertise;			// Adds [CSHP] to the Server Name
var() localized bool bOnlyAdminKick;		// Only the admins will be able to kick a user
var() localized bool bUseNumericIP;		// Use the Numeric IP instead of the string
var() localized bool bNGStatsOnly;		// Only allow NGStats Players
var() localized bool bAllowNoSmoke;		// Show we allow no smoke
var() localized bool bUseCSHPLog;		// Create separate CSHPLog files.
var() localized bool bFastTeams;		// Allow quick teams changes
var() localized int MaxInitTries;		// How many times should we try to connect to the client

	
var bool zzbInitialized;			// Has the mutie been initialized

// ----------------------------------------------------

var PlayerPawn zzPlayerList[32];  	// Players who have been replicated to
var CSHPCheatRI zzPlayerRIList[32];	// Quick access to their RI's
var int zzPlayerNetSpeed[32];		// Remember their last netspeed
var vector zzPlayerVList[32];	  	// Holds their current position vector
var int zzPlayerHeld[32];   		// is this Player Held in place 
var string zzCheatTestIP;	  	// Used to allow 1 player to cheat so admins can test
var string zzMyPacks;			// Used to retain ServerPackages values

//var CSHPWeb zzWeb;			// Used to talk to the web servers
var CSHPCheatReporter zzMyCheat;	// Used to log cheat messages
var localized string zzErrMsg;		// Used by CSHPMessage
var float zzTeamChangeTime;		// This would be to Prevent Team Change Spamming
var int zzGameState;			// Current Game State

var string VersionStr;			// Holds the version code from VUC++

// ----------------------------------------------------

var CSHPLog zzCheatLog;		// The CSHP Log

function xxPreDecrypt() {} // @@RemoveLine
event PreBeginPlay() { xxPreDecrypt(); }

// ===================================================================
// CLog - This is our logging code that outputs to a separate log file
// as well as the UnrealTournament/UCC.log
// ===================================================================
function xxCLog(string s)
{
local Pawn zzp;

	if (zzCheatLog!=None)
	{
		zzCheatLog.LogEventString(s);
		zzCheatLog.FileFlush();
	}
	// Send an event about the cheater to messaging spectators
	for (zzp = Level.PawnList; zzp != None; zzp = zzp.NextPawn)
	{
		if (zzp.IsA('MessagingSpectator'))
			zzp.ClientMessage("[CSHP]"@s, '');
	}
	Log(s);

} // CLog

// ===================================================================
// PostBeginPlay - Just show a message that we are loaded.
// ===================================================================
function PostBeginPlay()
{
local int zzi;

	Super.PostBeginPlay();

	// Open the CSHP log
	
	if (bUseCSHPLog)
		zzCheatLog = spawn(class 'CSHPLog');
		
	if (zzCheatLog!=None)
		zzCheatLog.StartLog();
	
	// Display the Startup Message to the logs
	xxclog("__________________________________________");
	xxclog("");
	xxclog("  ####   ####  #   #  ####");
	xxclog(" #      #      #   #  #   #");
	xxclog(" #       ###   #####  ####");
	xxclog(" #          #  #   #  #");
	xxclog("  ####  ####   #   #  #");
	xxclog("__________________________________________");
	xxclog("");
	xxclog("Version ....................... "$VersionStr);
	xxclog("Security Level is ............. "$SecurityLevel);
	xxclog("Security Frequency is ......... "$SecurityFrequency);
	xxclog("Security Tolerance is ......... "$SecurityTolerance);
	xxclog("Tracking FOV .................. "$TrackFOV);
	xxclog("Only Admin Kick ............... "$bOnlyAdminKick);
	xxcLog("Use Numeric IP ................ "$bUseNumericIP);
	xxcLog("NGStat Players Only ........... "$bNGStatsOnly);
	xxcLog("Allow NoSmoke ................. "$bAllowNoSmoke);
	xxcLog("Use CSHP Log .................. "$bUseCSHPLog);
	xxcLog("Fast Teams .................... "$bFastTeams);
	xxcLog("MaxInitTries .................. "$MaxInitTries);
	xxclog("");
	xxclog("__________________________________________");

	// Setup name advertising
	if ( (Advertise>0)  && (Level.NetMode != NM_Standalone) && (instr(Level.Game.GameReplicationInfo.ServerName,"[CSHP]")==-1) )
	{
		if (Advertise==1)
			Level.Game.GameReplicationInfo.ServerName = "[CSHP] "$Level.Game.GameReplicationInfo.ServerName;
		else if (Advertise==2)
			Level.Game.GameReplicationInfo.ServerName = Level.Game.GameReplicationInfo.ServerName$" [CSHP]";
	}
	// Announce yourself
	
	zzMyCheat = Spawn(class 'CSHPCheatReporter',self);
	if (zzMyCheat != None)
	{
		zzMyCheat.zzMyMutie = self;
	}
	else
		log("[CSHPs] Get ready for a lot of errors, can't spawn Cheat Reporter");
		
	zzCheatTestIP = "";
	
	// Register the Msg mutator
	Level.Game.RegisterMessageMutator(self);
					
} // PostBeingPlay
				
// ==================================================================================
// Tick - The work horse on the server side.  Each time the mutator will check the
// game for new players.  If one exists.. it will add him to the list and replicate 
// a CheatRI to him.
// ==================================================================================
function Tick(float DeltaTime)
{
	local int zzi,zzj, zzspd;
	local Pawn zzP;
	local CSHPCheatRI zzRI;
	local inventory zzInv;
	
	// Close the log when game ends
	if ((Level.Game.bGameEnded || Level.NextSwitchCountdown < 0.5) && zzCheatLog != None)
	{
		zzCheatLog.StopLog();
		zzCheatLog.Destroy();
		zzCheatLog = None;
	}
	
	// Track Game State changes
	if ((zzGameState != 2) && Level.Game.bGameEnded)
		zzGameState = 2;
	else if ((zzGameState == 0) && xxGameIsPlaying())
		zzGameState = 1;
	
	// Clean up after player who have left.

	for (zzI=0;zzI<32;zzI++)
	{
		zzP = zzPlayerList[zzi];
		zzRI = zzPlayerRIList[zzi];
		// Part 1: Cleanup
		if ( ( (zzP == None) || (zzP.bDeleteMe) ) && (zzRI!=None) )
		{
			zzPlayerList[zzI] = None;
			zzPlayerRIList[zzI].Destroy();
			zzPlayerRIList[zzI] = None;
			zzPlayerHeld[zzi] = 0;
			zzPlayerVList[zzi] = vect(0,0,0);
			zzP = None;
		}
		
		if (zzP != None)
		{
			// Report any gamestate change to clients
			if (zzRI != None)
				zzRI.zzGameState = zzGameState;
		
			// Part 2: Holding players until initialized
			if ( !zzP.IsInState('PlayerWaiting') )
			{
				if (zzPlayerHeld[zzi]==1)
				{
					if ( (zzPlayerRIList[zzi] != None) && (zzPlayerRIList[zzi].zzbInitialized ) )
					{
						zzPlayerHeld[zzi] = 0;
						if (!zzPlayerList[zzi].IsA('Spectator'))
						{
							zzPlayerList[zzi].SetPhysics(PHYS_Walking);				
							level.Game.RestartPlayer( zzPlayerList[zzi] );
						}
					}
					else
						zzPlayerList[zzi].SetLocation(zzPlayerVList[zzi]);
				}
				else if (!zzPlayerRIList[zzi].zzbInitialized )
				{
					if (!zzPlayerList[zzi].IsA('Spectator'))
					{
						zzPlayerList[zzi].Weapon = None;
						zzPlayerList[zzi].SelectedItem = None;	
						for( zzInv=zzPlayerList[zzi].Inventory; zzInv!=None; zzInv=zzInv.Inventory )
							zzInv.Destroy();		
				
						zzPlayerList[zzi].bHidden = true;
						zzPlayerList[zzi].SetPhysics(PHYS_None);
						zzPlayerList[zzi].SetCollision(false,false,false);
						zzPlayerVList[zzi] = zzPlayerList[zzi].Location;
					}
					zzPlayerHeld[zzi] = 1;
				}
				
			}
							
		}

	}
	// Part 3: creating CheatRI for those without one.
	for( zzP=Level.PawnList; zzP!=None; zzP=zzP.NextPawn )
	{
		if ( ( (zzP.IsA('PlayerPawn')) && (!zzp.IsA('Spectator')) && NetConnection(PlayerPawn(zzP).Player) != None && (!zzP.IsA('MessagingSpectator'))) && (xxFindPIndexFor(zzP) == -1) )
		{
		
			Log("[CSHPs]["$zzp.PlayerReplicationInfo.PlayerName$"] Spawning C"); //@@remove 
		
			zzi = 0;
			while ( (zzi<32) && (zzPlayerList[zzi]!=None) )
			  zzi++;
			  
			zzPlayerList[zzi] = PlayerPawn(zzP);
			zzPlayerHeld[zzi] = 0;
			
			zzRI = Spawn(class 'CSHPCheatRI',zzP,,zzP.Location);
			if (zzRI==None)
			{
				xxclog("[CSHPs] -- ERROR: CRI = None");
			}
			else
			{
				zzPlayerRIList[zzi] = zzRI;
				zzPlayerNetSpeed[zzi] = 0;
				zzRI.zzMyMutie = self;
				zzRI.zzSecurityLevel = SecurityLevel;
				if (TrackFOV > 0 && level.game.bAllowFOV)
					zzRI.zzWatchFOV = 0;
				
				zzRI.zzbNGStatsOnly = bNGStatsOnly;
				zzRI.zzCheat = zzMyCheat;
				zzRI.zzbAllowNoSmoke = bAllowNoSmoke;
				zzMyCheat.xxClientLoggedIn(zzP,zzRI);
				
				zzRI.zzTimeOutGrace = Level.TimeSeconds + (SecurityFrequency * Level.TimeDilation * 3);
				
			}
		}
	}
	
/*	
	// Part 4: Cleanup again ?
	for (zzi=0;zzi<32;zzi++)
	{
	    if (zzPlayerList[zzi] != None)
		{
			if ( (zzPlayerRIList[zzi] == None) || (zzPlayerRIList[zzi].bDeleteMe) || (zzPlayerList[zzi].bDeleteMe) )
			{
				zzPlayerRIList[zzi] = None;
				zzPlayerList[zzi] = None;
			}
		}
	}
*/	

} // Tick  

// ==================================================================================
// FindPIndexFor - Finds the PlayerList Index for a pawn.  Return -1 if not in the list
// ==================================================================================
function int xxFindPIndexFor(pawn zzP)
{
	local int zzi;
	
	for (zzi=0;zzi<32;zzi++)
	{
		if ( (zzPlayerList[zzi]!=None) && (zzPlayerList[zzi]==zzP) )
			return zzi;
	}
	
	return -1;

} // FindPIndexFor

// ==================================================================================
// Mutate - Accepts commands from the users
// ==================================================================================
function Mutate(string MutateString, PlayerPawn Sender)
{
	local PlayerPawn zzP;
	local int zzi;
	local bool zzb;

	// Kick any cheaters
	
	if (MutateString ~= "CheatKick")
	{
	
		if ( (!bOnlyAdminKick) || (Sender.bAdmin) )
		{
	
			for (zzi=0;zzi<32;zzi++)
			{
				if ( (zzPlayerList[zzi]!=None) && (zzPlayerRIList[zzi] !=None) && (zzPlayerRIList[zzi].zzbBadGuy) )
					zzPlayerList[zzi].Destroy();
			}
		}
	}
	
	// Show any cheaters online
	
	else if (MutateString ~= "CheatShow")
	{
		zzb=false;
		for (zzi=0;zzi<32;zzi++)
		{
			if ( (zzPlayerList[zzi]!=None) && (zzPlayerRIList[zzi] !=None) && (zzPlayerRIList[zzi].zzbBadGuy) )
			{
				zzb=true;
				Sender.ClientMessage(""$zzPlayerList[zzi].PlayerReplicationInfo.PlayerName$" is cheating - "$zzPlayerRIList[zzi].zzLastCheat,,true);
			}
		}
		
		if (!zzb)
		{
			Sender.ClientMessage("No-one is cheating.");
		}
		
	}
	
	// Return info about CSHP.
	
	else if (MutateString ~= "CheatInfo")
	{
		Sender.ClientMessage("This server is running "$VersionStr);
		Sender.ClientMessage("Security Level is: "$SecurityLevel);
		Sender.ClientMessage("Tracking FOV: "$TrackFOV);
		Sender.ClientMessage("Only Admin Kick: "$bOnlyAdminKick);
		Sender.ClientMessage("NGStats Only: "$bNGStatsOnly);
		Sender.ClientMessage("Allow NoSmoke: "$bAllowNoSmoke);
		Sender.ClientMessage("Use CSHP Log: "$bUseCSHPLog);
		Sender.ClientMessage("Fast Teams: "$bFastTeams);
	}
	
	// Allow admins to test a cheat
	
	else if ( (MutateString ~= "CheatTest") && (Sender.bAdmin) )
	{
		zzCheatTestIP = zzP.GetPlayerNetworkAddress();
		Sender.ClientMessage("The IP "$zzCheatTestIP$" is exempt from Cheat logging for the rest of this map");
		xxcLog("[CSHPs] : The IP "$zzCheatTestIP$" is exempt from Cheat logging for the rest of this map (set by"$PlayerPawn(Owner).PlayerReplicationInfo.PlayerName$")");
	}
	
	else if (bFastTeams && MutateString ~= "FixTeams")
		MakeTeamsEven(Sender);
	else if (bFastTeams && MutateString ~= "NextTeam")
		NextTeam(Sender);
	else if (bFastTeams && Left(MutateString, 11) ~= "ChangeTeam")
		SetTeam(Sender, Mid(MutateString, 12)); 
	   
	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

} // Process the mutate commands

// ==================================================================================
// NextTeam - Allow a player to switch team (DB Request)
// ==================================================================================
// This is where i would like to put my personal contribution to the project. See
// it as the big brother of EZTeams. I will put code if allowed to. But Please
// Dr ... allow me to do so. Its so practical to be able to switch team fast
// when having a CTF tournament match and you join in the wrong team color.

function NextTeam(PlayerPawn zzp)
{
local int nWantedTeam;
local TeamGamePlus tgp;
local float zzOldTeam;

	if (Level.Game.bTeamGame && Level.Game.IsA('TeamGamePlus')
			 && (((Level.TimeSeconds - zzTeamChangeTime) > 60) || (!xxGameIsPlaying() && (Level.TimeSeconds - zzTeamChangeTime) > 5)))
	{
		tgp = TeamGamePlus(Level.Game);
		zzOldTeam = zzp.PlayerReplicationInfo.Team;
		nWantedTeam = zzOldTeam + 1;

		if (nWantedTeam >= tgp.MaxTeams)
			nWantedTeam = 0;
			
		zzp.ChangeTeam(nWantedTeam);
		if (zzp.PlayerReplicationInfo.Team != zzOldTeam)
		{
			// View from self if changing team is valid 
			if (zzp.ViewTarget != None)
			{
				zzp.bBehindView = false;
				zzp.ViewTarget = None;
			}
			zzTeamChangeTime = Level.TimeSeconds;
		}
	}
}

// ==================================================================================
// MakeTeamsEven - Switch player from team if teams are uneven. (DB Request)
// ==================================================================================
// This is where i would like to put my personal contribution to the project. See
// it as the big brother of EZTeams. I will put code if allowed to. But Please
// Dr ... allow me to do so. Teams become uneven so often its not funny.
function MakeTeamsEven(PlayerPawn zzp)
{
local int zzOldTeam, lowTeam, i, lowTeamSize;
local TeamGamePlus tgp;

	// Start by checking if fix is needed base on gametype
	if (Level.Game.IsA('TeamGamePlus') && Level.Game.bTeamGame)
	{
		tgp = TeamGamePlus(Level.Game);

		lowTeamSize = 128;
		for (i = 0; i<tgp.MaxTeams; i++)
		{
			if (tgp.Teams[i].Size < lowTeamSize)
			{
				lowTeamSize = tgp.Teams[i].Size;
				lowTeam = i;
			}
		}

		zzOldTeam = zzp.PlayerReplicationInfo.Team;
		if ((tgp.Teams[zzOldTeam].Size - lowTeamSize) < 2)
			return;
		
		Level.Game.ChangeTeam(zzp, lowTeam);
		if (zzp.PlayerReplicationInfo.Team != zzOldTeam )
		{
			// @@TODO : Handling of warshell ?
			if (zzp.ViewTarget != None)
			{
				zzp.bBehindView = false;
				zzp.ViewTarget = None;
			}
			// Use our own implementation of died
			xxDied(zzp);
			zzTeamChangeTime = Level.TimeSeconds;
		}
	}
}

function SetTeam(PlayerPawn zzp, string zzsteam)
{
local bool zzbvalid;
local int zzOldTeam, zzteam;

	if (Level.Game.bTeamGame && Level.Game.IsA('TeamGamePlus')
			 && (((Level.TimeSeconds - zzTeamChangeTime) > 60) || (!xxGameIsPlaying() && (Level.TimeSeconds - zzTeamChangeTime) > 5)))
	{
		zzbvalid = true;
		if (zzsteam ~= "red" || zzsteam ~= "0")
			zzteam = 0;
		else if (zzsteam ~="blue" || zzsteam ~= "1")
			zzteam = 1;
		else if (zzsteam ~="green" || zzsteam ~= "2")
			zzteam = 2;
		else if (zzsteam ~="gold" || zzsteam ~= "3")
			zzteam = 3;
		else
			zzbvalid = false;
		
		if (!zzbvalid && zzteam >= TeamGamePlus(Level.Game).MaxTeams)
			zzbvalid = false;
		
		if (!zzbvalid)
		{
			zzp.ClientMessage("Wrong team selected : "$zzsteam);
			return;
		}

		// Ok .. chosen a good team
		zzOldTeam = zzp.PlayerReplicationInfo.Team;
		zzp.ChangeTeam(zzteam);
		if (zzp.PlayerReplicationInfo.Team != zzOldTeam)
		{
			// View from self if changing team is valid 
			if (zzp.ViewTarget != None)
			{
				zzp.bBehindView = false;
				zzp.ViewTarget = None;
			}
			zzTeamChangeTime = Level.TimeSeconds;
		}
	}
}


// This is my own version of Died used when player makes teams even,
// Using xxDies() will just report a team change but no suicide to ngStats.
function xxDied(pawn zzp)
{
local pawn OtherPawn;
local actor A;

	if (xxGameIsPlaying())
	{		
		zzp.Health = Min(0, zzp.Health);
		for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
			OtherPawn.Killed(zzp, zzp, '');
	
		if( zzp.Event != '' )
			foreach AllActors( class 'Actor', A, zzp.Event )
				A.Trigger( zzp, None );
			
		Level.Game.DiscardInventory(zzp);
		Velocity.Z *= 1.3;
		if ( zzp.Gibbed('Suicided') )
		{
			zzp.SpawnGibbedCarcass();
			zzp.HidePlayer();
		}
		zzp.PlayDying('Suicided', zzp.Location);

		if ( zzp.RemoteRole == ROLE_AutonomousProxy )
			zzp.ClientDying('Suicided', zzp.Location);
		
		zzp.GotoState('Dying');
	}
}

// ==================================================================================
// GameIsPlaying - Tells if game is currently in progress
// ==================================================================================
function bool xxGameIsPlaying()
{
local DeathMatchPlus DMP;

	// Determine if match has started or ended (server side only) 
	// should i assume DMP be default for net games ?
	if (Level.Game.IsA('DeathMatchPlus'))
	{
		DMP = DeathMatchPlus(Level.Game); 
		if (DMP.bGameEnded || (DMP.bRequireReady && (DMP.CountDown > 0)))
			return false;
	}
	return true;
}


// ==================================================================================
// Destroyed - Shut down the log
// ==================================================================================
event Destroyed()
{
	Super.Destroyed();
	if (zzCheatLog!=None)
	{
		zzCheatLog.StopLog();
		zzCheatLog.Destroy();
		zzCheatLog = None;
	}
}

// ==================================================================================
// MutatorBroadcastMessage - Stop Message Hacks
// ==================================================================================

function bool MutatorBroadcastMessage( Actor Sender,Pawn Receiver, out coerce string Msg, optional bool bBeep, out optional name Type )
{
	local Actor A;
	local bool legalspec;
	A = Sender;
	
	// Hack ... for AdminLogout() going in PHYS_Walking while state is 'PlayerWaiting'
	If (A.IsA('GameInfo') && Receiver != None && Receiver.PlayerReplicationInfo != None
			&& (Receiver.PlayerReplicationInfo.PlayerName@"gave up administrator abilities.") == Msg
			&& (Receiver.GetStateName() == 'PlayerWaiting' || Receiver.PlayerReplicationInfo.bIsSpectator))			

	{
		Receiver.GotoState('');
		Receiver.GotoState('PlayerWaiting');
	} 
	
	while (!A.isa('Pawn') && A.Owner != None)
		A=A.Owner;

	if (A.isa('spectator'))
		legalspec=((left(msg,len(spectator(A).playerreplicationinfo.playername)+1))==(spectator(A).playerreplicationinfo.playername$":") || A.IsA('MessagingSpectator'));		

	if (legalspec)
		 legalspec=(type=='Event');                
		 
	if (A.isa('Pawn') && !legalspec)
		return false;
                        
	return Super.MutatorBroadcastMessage( Sender,Receiver, Msg, bBeep );
}

// ==================================================================================
// MutatorBroadcastLocalizedMessage - Stop Message Hacks
// ==================================================================================
function bool MutatorBroadcastLocalizedMessage( Actor Sender, Pawn Receiver, out class<LocalMessage> Message, out optional int Switch, out optional PlayerReplicationInfo RelatedPRI_1, out optional PlayerReplicationInfo RelatedPRI_2, out optional Object OptionalObject )
{
	local Actor A;
	A = Sender;
	while (!A.isa('Pawn') && A.Owner != None) 
	  A=A.Owner;

	if (A.isa('Pawn'))
		return false;
	
	return Super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );

} // MutatorBroadcastLocalizedMessage

// ==================================================================================
// ModifyLogin - Checks that a skin is not part of Botpack (temporary fix)
// ==================================================================================
function ModifyLogin(out class<playerpawn> SpawnClass, out string Portal, out string Options)
{
	local class<TournamentPlayer> tpc;
	local string zzInSkin, zzInFace;
	local texture zztex;
	
	Super.ModifyLogin(SpawnClass, Portal, Options);
	
	tpc = class<TournamentPlayer>(SpawnClass);
	if (tpc != None)
	{
		// now, check for invalid skin names ...
		zzInSkin = Caps(xxGetClass(Level.Game.ParseOption(Options, "Skin" )));
		zzInFace = Caps(xxGetClass(Level.Game.ParseOption(Options, "Face" )));
	
 		if (!xxValidSP(zzInSkin) || (zzInFace != "" && !xxValidSP(zzInFace) ))		
		{
			Options = xxFixOption(Options, "Skin", tpc.default.DefaultSkinName);
			Options = xxFixOption(Options, "Face", "");
		}
	}
	
}

// ==================================================================================
// FixOption - Changes an Option String part with a new Value 
// ==================================================================================
function string xxFixOption(string Options, string inKey, string value)
{
local string newOption, pair, xKey, xVal;

	newOption = "";
	while (Level.Game.GrabOption(Options, pair))
	{
		Level.Game.GetKeyValue(pair, xKey, xVal);
		if (xKey ~= inKey)
			newOption = newOption $ "?" $ xKey $ "=" $ value;
		else
			newOption = newOption $ "?" $ pair;
	}
	return newOption;
}

// ==================================================================================
// GetClass - Returns the package part of a class name
// ==================================================================================
function string xxGetClass(string zzClassname)
{
	local string zzcls;
	local int zzp;

	zzcls = Caps(zzClassname);
	zzp = instr(zzcls,".");
	return left(zzcls,zzp);
}

function bool xxValidSP(string zzPackname)
{
	local int zzp;

	if (zzMyPacks == "")
		zzMyPacks = Caps(ConsoleCommand("get engine.gameengine serverpackages"));

	zzp	= instr(zzMyPacks, Chr(34)$zzPackname$Chr(34));
	if (zzp == -1 || zzPackname ~= "BOTPACK")
		return false;
	
	return true;
}

// ==================================================================================
// PreventDeath - Prevent spectators or inactive players from becoming a chess piece.
// ==================================================================================
function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local int zzCRINo;
local CSHPCheatRI zzCRI;
local PlayerReplicationInfo zzPRI;
local CTFFlag zzflag;
	
	// Fix for persistent flag
	if (Killer != None && Killer.PlayerReplicationInfo != None)
	{
		zzPRI = Killer.PlayerReplicationInfo;
		if (zzPRI.HasFlag != None)
		{
		zzflag = CTFFlag(zzPRI.HasFlag);
		
			if (zzflag.Holder != None && zzflag.Holder != Killer)
				zzPRI.HasFlag = None;
		}
	}
	
	zzCRINo = xxFindPIndexFor(Killer);
	if (zzCRINo>-1) 
	{
		zzCRI = zzPlayerRIList[zzCRINo];
		
		if ( zzCRI.xxCheckTimeStamp(0.0) )
		{
			return true;
		}
	}
	 
	if (Killed != None && !xxIsPlaying(Killed))
	{
		return true;
	}
	
	return Super.PreventDeath(Killed, Killer, damageType, HitLocation);
}

// ==================================================================================
// IsPlaying - Tells if the player is currently playing the game
// ==================================================================================
function bool xxIsPlaying(Pawn zzOther)
{
local PlayerReplicationInfo zzPRI;

	zzPRI = zzOther.PlayerReplicationInfo;
	if ((zzPRI!=None && (zzPRI.bIsSpectator || zzPRI.bWaitingPlayer)) || Caps(zzOther.GetStateName()) == "GAMEENDED")
		return false;

	return true;
}

// ==================================================================================
// HandlePickupQuery - Fix the messed up inv touching array before giving an item
// ==================================================================================
function bool HandlePickupQuery(Pawn Other, Inventory item, out byte bAllowPickup)
{
local bool bValid;
local int i;
local Inventory belt, pads, armor;

	bValid = false;
	for (i = 0; i<4; i++)
	{
		if (Other.Touching[i] == item)
			bValid=true;
	}
	if (!bValid)
		return false;

	if (item.IsA('UT_ShieldBelt'))
	{
		item.Default.Charge=150;
	}
	else if (item.IsA('Armor2') || item.IsA('ThighPads'))
	{
		belt = Other.FindInventoryType(class'UT_ShieldBelt');
		if (belt != None)
		{
			belt.Default.Charge = 150;
			pads = Other.FindInventoryType(class'ThighPads');
			armor = Other.FindInventoryType(class'Armor2');
		
			// Only care if Belt+Pads are present
			if (item.IsA('Armor2') && pads != None)
				belt.Default.Charge = 150 - pads.charge;
			else if (item.IsA('ThighPads') && armor != None)
				belt.Default.Charge = 150 - armor.charge;
		}
	}	
	return super.HandlePickupQuery(Other, item, bAllowPickup);
}


defaultproperties
{
	VersionStr="CSHP4 v1.7.29"
}

