//=============================================================================
// CheatRI.
//
// The CheatRI is a replicated actor that is used to police the system and
// talk with the server.
//
// (c) 2001, Midnight Interactive
//=============================================================================

class CSHPCheatRI expands ReplicationInfo;

// -------- Anti Hacking Variables

var string StrTab[255];
var string zzDECSTRTAB[255];
var string encoding_table[64];	
var int	zzKeyNdx;	
var bool zzbDebug;

var string VersionStr;			// Holds the version code from VUC++

// -------- Replicated Variables

var int zzWatchFOV;			// Should we Watch the fov
var int zzSecurityLevel;		// What is the secruity level (0=log, 1=kick, 2=ban)
var bool zzbNGStatsOnly;		// Only allow NGStat's players
var bool zzbAllowNoSmoke;		// Allow NoSmoke
var int zzGameState;			// Current game state, 0=NotStarted, 1=InPlay, 2=GameEnded

// --------- Check flags

struct xxtGCF
{
        var bool zzbCheckVR;		// Has the VR always been legal
        var bool zzbCheckFire;		// Has the Fire/altfire always been legal
        var bool zzbCheckPlayer;	// Is our player legal
	var bool zzbCheckConsole;	// Has the console always been legal	
};

var xxtGCF zzbGlobalCheckFlags;	// Holds the replicated checks
		 
// --------- Used on Both sides

var bool zzbInitialized;		// Has the CheatRI been initialized
var float zzTimeStamp;			// Used for hack detection

// --------- Client Side Variables

var float zzOrigFOV;			// Holds the FOV of the player when they first enter the game
var float zzTimeCheck;			// Count down to the next check 

var bool zzbClientMsgWaiting;		// There is a message waiting for this client 
var int	zzClientMsgType;		// What type of message (0=warning,1=bad)
var string zzClientMsg;			// What is the message 

var PlayerPawn zzMyPlayer;		// Points to the PlayerPawn that owns this player
var CSHPConsole zzMyConsole;		// Points to the console of the Player Pawn that owns this player
var CSHPBadge zzMyBadge;		// Points to our hud mutator

var int zzCanvasGrace;			// You are allow 5 bad canvas positions in a row

var int zzAckDelay;			// Delay the ACK fora bit

var bool zzbGlobalVRCheck;		// Holds the status of all VR checks
var bool zzbGlobalFireCheck;		// Holds the status of all Fire checks

var rotator zzMyVR;			// Used to track VR 
var byte zzbFire, zzbAltFire;		// Used to track fire buttons

var bool zzbIsMac, zzbIsPC, zzbIsLinux;	// Client System Type
var bool zzbHasVR;			// Just to tell we grabbed VR in this tick

var bool zzbSetPlayerAlready;		

// --------- Server Side Variables

var string zzLastCheat;			// Last Cheat occured when
var HackProtection zzMyMutie;		// Pointer back to the Hack Protection
var bool zzbBadGuy;			// Used with Logging, has this guy already been reported.
var CSHPCheatReporter zzCheat;		// Used to log cheats

var float zzLastHey;			// Holds the time when the last HEYServer was received
var int zzClientInitStatus;		// Were in the init process is the client
var int zzClientInitTries;		// How many times have we tried to init the client
var int zzLastServerMsg;		// What was the last server message;
var float zzTimeOutGrace;		// Used to determine the grace period before a timeout
					// on the initial join

// --------- Packages validation
var int zzNames, zzNameSize, zzImports, zzExports, zzGenerations, zzLazyLoaders;
var string zzLookupName;
var int zzInvalidConsoleCnt;

replication
{
	// Function the Client calls on the Server

	reliable if (Role < ROLE_Authority)
		xxDoServerMsg, xxServerLog, xxServerLog2;
	
	reliable if ( Role < ROLE_Authority )
		xxServerACK, xxServerGo, xxHeyServer;
                       
	// Variables on the client the server can access

	reliable if ( Role == ROLE_Authority )
		zzSecurityLevel, zzWatchFOV, zzbNGStatsOnly, zzbAllowNoSmoke, zzGameState;
		
	// Functions the server calls on the client.

	reliable if ( ROLE == ROLE_Authority)
		xxClientGo,xxClientGoCrashYourself;
	
	reliable if ( Role == ROLE_Authority )
		xxClientACK,  xxHeyClient;

}

function xxPreDecrypt() {} // @@RemoveLine


// ==================================================================================
// ==================================================================================
// ==================================================================================

// Initialzation code

// ==================================================================================
// ==================================================================================
// ==================================================================================


// ==================================================================================
// PostNetBeginPlay - Start everything up 
// ==================================================================================
simulated event PostNetBeginPlay ()
{
	Super.PostNetBeginPlay();

	if ( (Level.NetMode == NM_Client && ROLE < ROLE_SimulatedProxy) || (!bNetOwner) )        
		return;
	
	xxPreDecrypt();	// Decrypt the CRI on this client		

		
	zzOrigFov = -1;
        zzAckDelay = 5;
		
        GotoState('xxClientInitializing');
	
}

// ==================================================================================
// ==================================================================================
// ==================================================================================

// Anti-Debugging/Compile code

// ==================================================================================
// ==================================================================================
// ==================================================================================


// =====================================================================
// VerifyCompile - This function get's fixed up after compile so that
// the log hids a return statement.
// =====================================================================		
simulated function xxVerifyCompile()
{
}

// =====================================================================
// VerifyClass - This function checks the class name to make sure it's
// set to 0x02 0x0A 0x0D.
// =====================================================================		
simulated function xxVerifyClass()
{
}

// ==================================================================================
// ==================================================================================
// ==================================================================================

// Misc Utility code

// ==================================================================================
// ==================================================================================
// ==================================================================================

        
// ==================================================================================
// AttachConsole - Adds our console
// ==================================================================================
simulated function xxAttachConsole()
{
	local CSHPConsole c;
	local UTconsole oldc;
       
	if (zzMyConsole == None)
	{
		zzMyConsole = CSHPConsole(zzMyPlayer.Player.Console);
		if (zzMyConsole == None)
		{
                
			zzMyPlayer.Player.Console.Disable('Tick');
			c = New(None) class'CSHPConsole';
			if (c != None)
			{
				oldc = UTConsole(zzMyPlayer.Player.Console);
				c.zzMyCheatRI = self;
				c.zzOldConsole = oldc;
				zzMyPlayer.Player.Console = c;
				zzMyConsole = c;
				zzMyConsole.xxGetValues(); //copy all values from old console to new
                                zzMyConsole.ConsoleWindow.WindowTitle = "Console - "$zzMyBadge.VersionStr;

			}
                        else
                          xxDoClientMsg(1,1,"");	// CSHP Restricted
		}
		else if (zzmyplayer.player.console.class!=class'CSHPconsole')
		{
			zzbBadGuy=true;
			xxDoClientMsg(1,2,""$zzmyplayer.player.console.class); // "Console illegal Altered
			zzmyplayer.consolecommand("disconnect");

		} //disconnect if hacking.
	}

}

// ==================================================================================
// AttachBadge - Adds our hud controller/mutator 
// ==================================================================================

simulated function xxAttachBadge()
{
	local Mutator zzHM;

	// Spawn the hud

	if ( (zzMyBadge != None) || (zzMyPlayer == None) || (zzMyPlayer.MyHud==None) )
	{
		return;
	}

	zzMyBadge = Spawn(class 'CSHPBadge',zzMyPlayer);
	if (zzMyBadge == None)
		xxServerlog("Couldn't Spawn Badge");
	else
	{
		// Decrypt the badge
		
		zzMyBadge.xxPreDecrypt();
	
		// Attach it to the player

		zzHM = zzMyPlayer.myHud.HudMutator;
		if (zzHM != None)
		{
			zzMyBadge.zzNextHUD = zzHM;
		}
		zzMyBadge.zzMyCheatRI = self;
		zzMyPlayer.myHud.HudMutator = zzMyBadge;
	}

} // AttachBadge

// ==================================================================================
// TestPlayer - Checks to make sure the player is good
// ==================================================================================
simulated function bool xxTestPlayer()
{
	return ( (Playerpawn(Owner)==None) || (PlayerPawn(Owner) != zzMyPlayer)  || zzMyPlayer.Player==None );
}

// ==================================================================================
// TestConsole - Tests to make sure the console is good
// ==================================================================================

simulated function bool xxTestConsole()
{
	
	return ( (zzMyConsole==None) || (zzMyPlayer.Player.Console != zzMyConsole) || zzMyPlayer.Player.Console.Class != Class'CSHPConsole' );	
}

// ==================================================================================
// CheckVR - Checks for an aimbot by looking at the VR after a Tick/PostRender call 
// on the console
// ==================================================================================
simulated function xxCheckVR(Canvas zzCanvas, float delta)
{
	local rotator zzOldViewRotation,zzr;
	local string zzpstate;
        local bool zzbCheckMod,zzbCheckVR, zzbCheckFire;

	zzpstate = ""$zzMyPlayer.GetStateName();

        zzbCheckMod = ( (Level.Pauser == "") && (zzpstate ~= "PlayerWalking" || zzpstate ~= "PlayerSwimming") && zzMyPlayer.Weapon != None && !zzMyPlayer.Weapon.IsA('WarHeadLauncher') && zzGameState == 1 );        
        zzbCheckMod = zzbCheckMod && zzbHasVR;
        
	// Check view rotations
	zzbCheckVR = (Normalize(zzMyPlayer.ViewRotation) != Normalize(zzMyVR));
        zzbCheckFire = (zzMyPlayer.bFire != zzbFire || zzMyPlayer.bAltFire != zzbAltFire);
       
	zzbCheckVR = zzbCheckVR && zzbCheckMod;
        zzbCheckFire = zzbCheckFire && zzbCheckMod;
        
	zzbGlobalCheckFlags.zzbCheckVR = (zzbGlobalCheckFlags.zzbCheckVR || zzbCheckVR);
        zzbGlobalCheckFlags.zzbCheckFire = (zzbGlobalCheckFlags.zzbCheckFire || zzbCheckFire);        

	if (zzbCheckVR)         	
	{
		zzbBadGuy=true;
			xxDoClientMsg(1,4,""); // "Illegal Rogue Aimbot Detected! "$xxIdCheat());
	}

	if (zzbCheckFire) 
	{
		zzbBadGuy=true;
		xxDoClientMsg(1,5,""); // "Illegal FIRE/ALTFIRE Command Detected
	}
      
        
}

// ==================================================================================
// ==================================================================================
// ==================================================================================

// UCRC code

// ==================================================================================
// ==================================================================================
// ==================================================================================


// ==================================================================================
// CheckPackages - Verifies all the packages

simulated function bool xxCheckPackages ()
{
	local string zzt, zzPackages, zzPackage;
	local bool zzbValid;
	local xxCSHPcc zzactor;
	local spawnnotify sn;
	
	//we need to work on a NICE way of not allowing older versions of UT, and tell them where/how to upgrade
	if (!xxValidVersion()) 
        {
        	xxDoClientMsg(2,-1,""); // ""$Level.EngineVersion);
        	return true;
        }
	
	zzbValid = true;

	sn = level.SpawnNotify;
	level.SpawnNotify = none;

	zzActor = spawn(class'xxCSHPcc');

	level.SpawnNotify = sn;
		
	if (zzActor==None)
	{		
                return false;
	}
		
	if (zzActor.Class != class 'xxCSHPcc')		
	{		
                return false;
	}
		
	
	zzPackages = zzActor.ConsoleCommand("OBJ LINKERS");
	zzActor.Destroy();
        
        if (zzPackages=="")
        {
                return false;
        }
       
 	zzPackage = xxParsePackage(zzPackages);
	while (zzPackage != "" && zzbValid)
	{
		xxParseLine(zzPackage);
		switch( zzLookupName )
		{
			case "Core 436":
				zzbValid = xxCheckValues(327, 10, 16, 669, 10, 0);
				break;
//../System/Core.u (Package Core): Names=327 (1K/10K) Imports=16 (0K) Exports=669 (23K) Gen=10 Lazy=0

			case "Engine 436":
				zzbValid = xxCheckValues(3348, 112, 60, 5370, 17, 1);
				break;
//../System/Engine.u (Package Engine): Names=3348 (13K/112K) Imports=60 (1K) Exports=5370 (188K) Gen=17 Lazy=47

			case "IpDrv 436":
				zzbValid = xxCheckValues(136, 4, 28, 168, 10, 0);
				break;
//../System/IpDrv.u (Package IpDrv): Names=136 (0K/4K) Imports=28 (0K) Exports=168 (5K) Gen=10 Lazy=0

			case "Fire 436":
				zzbValid = xxCheckValues(181, 5, 15, 108, 10, 0);
				break;
//../System/Fire.u (Package Fire): Names=181 (0K/5K) Imports=15 (0K) Exports=108 (3K) Gen=10 Lazy=0

			case "UnrealShare 436":
				zzbValid = xxCheckValues(4604, 143, 787, 8865, 3, 1);
				if (!zzbValid)
					zzbValid = xxCheckValues(4563, 143, 787, 8773, 1, 0);
				break;
//../System/UnrealShare.u (Package UnrealShare): Names=4605 (17K/143K) Imports=787 (21K) Exports=8865 (311K) Gen=4 Lazy=1437

//			case "UnrealShare 432":
//				zzbValid = xxCheckValues(4563, 143, 787, 8773, 1, 0);
//				break;
//../System/UnrealShare.u (Package UnrealShare): Names=4563 (17K/143K) Imports=787 (21K) Exports=8773 (308K) Gen=1 Lazy=1329

			case "UnrealI 436":
				zzbValid = xxCheckValues(2201, 68, 670, 3017, 1, 0);
				break;
//../System/UnrealI.u (Package UnrealI): Names=2201 (8K/68K) Imports=670 (18K) Exports=3017 (106K) Gen=1 Lazy=40

			case "Botpack 436":
				zzbValid = xxCheckValues(7625, 194, 1490, 12695, 14, 0);
				break;
//../System/Botpack.u (Package Botpack): Names=7625 (29K/194K) Imports=1490 (40K) Exports=12695 (446K) Gen=14 Lazy=3806

			case "UWindow 436":
				zzbValid = xxCheckValues(1407, 46, 98, 3423, 10, 0);
				break;
//../System/UWindow.u (Package UWindow): Names=1407 (5K/46K) Imports=98 (2K) Exports=3423 (120K) Gen=10 Lazy=24

			case "UMenu 436":
				zzbValid = xxCheckValues(2012, 62, 503, 3068, 12, 0);
				if (!zzbValid && zzbIsMac)
					zzbValid = xxCheckValues(1716, 41, 503, 2776, 1, 0);
                                else if (!zzbValid && zzbIsLinux)
                                	zzbValid = xxCheckValues(1711, 41, 502, 2773, 1 ,0);
				break;
//../System/UMenu.u (Package UMenu): Names=2012 (7K/62K) Imports=503 (13K) Exports=3068 (107K) Gen=12 Lazy=13

    		case "UBrowser 436":
    			zzbValid = xxCheckValues(1082, 37, 269, 1843, 10, 0);
    			break;
//../System/UBrowser.u (Package UBrowser): Names=1082 (4K/37K) Imports=269 (7K) Exports=1843 (64K) Gen=10 Lazy=0

			case "UTServerAdmin 436":
				zzbValid = xxCheckValues(326, 11, 127, 353, 10, 0);
				break;
//../System/UTServerAdmin.u (Package UTServerAdmin): Names=326 (1K/11K) Imports=127 (3K) Exports=353 (12K) Gen=10 Lazy=0

			case "UTBrowser 436":
				zzbValid = xxCheckValues(138, 4, 68, 63, 10, 0);
				break;
//../System/UTBrowser.u (Package UTBrowser): Names=138 (0K/4K) Imports=68 (1K) Exports=63 (2K) Gen=10 Lazy=0

			case "UTMenu 436":
				zzbValid = xxCheckValues(1984, 62, 720, 3065, 11, 0);
				if (!zzbValid && zzbIsMac)
					zzbValid = xxCheckValues(1761, 41, 719, 2853, 1, 0);
				break;
//../System/UTMenu.u (Package UTMenu): Names=1984 (7K/62K) Imports=720 (19K) Exports=3065 (107K) Gen=11 Lazy=0

			case "UWeb 436":
				zzbValid = xxCheckValues(153, 4, 35, 156, 10, 0);
				break;
//../System/UWeb.u (Package UWeb): Names=153 (0K/4K) Imports=35 (0K) Exports=156 (5K) Gen=10 Lazy=0

			case "IpServer 436":
				zzbValid = xxCheckValues(142, 4, 59, 158, 11, 0);
				break;
//../System/IpServer.u (Package IpServer): Names=142 (0K/4K) Imports=59 (1K) Exports=158 (5K) Gen=11 Lazy=0

			case "Engine 432":
				zzbValid = xxCheckValues(3345, 112, 60, 5370, 14, 0);
				break;
//../System/Engine.u (Package Engine): Names=3345 (13K/112K) Imports=60 (1K) Exports=5370 (188K) Gen=14 Lazy=46

			case "Core 432":
				zzbValid = xxCheckValues(326, 10, 16, 669, 9, 0);
				break;
//../System/Core.u (Package Core): Names=326 (1K/10K) Imports=16 (0K) Exports=669 (23K) Gen=9 Lazy=0

			case "Fire 432":
				zzbValid = xxCheckValues(180, 5, 15, 108, 9, 0);
				break;
//../System/Fire.u (Package Fire): Names=180 (0K/5K) Imports=15 (0K) Exports=108 (3K) Gen=9 Lazy=0

			case "Botpack 432":
				zzbValid = xxCheckValues(7453, 198, 1490, 12393, 12, 0);
				break;
//../System/Botpack.u (Package Botpack): Names=7453 (29K/198K) Imports=1490 (40K) Exports=12393 (435K) Gen=12 Lazy=3577

			case "UnrealI 432":
				zzbValid = xxCheckValues(2201, 68, 670, 3017, 1, 0);
				break;
//../System/UnrealI.u (Package UnrealI): Names=2201 (8K/68K) Imports=670 (18K) Exports=3017 (106K) Gen=1 Lazy=40

			case "UMenu 432":
				zzbValid = xxCheckValues(1919, 62, 503, 2977, 10, 0);
                                if (!zzbValid)
                                	zzbValid = xxCheckValues(2009,62, 503, 3067, 10, 0);
				break;
//../System/UMenu.u (Package UMenu): Names=1919 (7K/62K) Imports=503 (13K) Exports=2977 (104K) Gen=10 Lazy=13

			case "UWindow 432":
				zzbValid = xxCheckValues(1406, 46, 98, 3423, 9, 0);
				break;
//../System/UWindow.u (Package UWindow): Names=1406 (5K/46K) Imports=98 (2K) Exports=3423 (120K) Gen=9 Lazy=24

			case "UBrowser 432":
				zzbValid = xxCheckValues(1080, 37, 269, 1842, 9, 0);
				break;
//../System/UBrowser.u (Package UBrowser): Names=1080 (4K/37K) Imports=269 (7K) Exports=1842 (64K) Gen=9 Lazy=0

			case "UTBrowser 432":
				zzbValid = xxCheckValues(137, 4, 68, 63, 9, 0);
				break;
//../System/UTBrowser.u (Package UTBrowser): Names=137 (0K/4K) Imports=68 (1K) Exports=63 (2K) Gen=9 Lazy=0

			case "IpDrv 432":
				zzbValid = xxCheckValues(135, 4, 28, 168, 9, 0);
				break;
//../System/IpDrv.u (Package IpDrv): Names=135 (0K/4K) Imports=28 (0K) Exports=168 (5K) Gen=9 Lazy=0

			case "UTMenu 432":
				zzbValid = xxCheckValues(1983, 62, 720, 3065, 10, 0);
				break;
//../System/UTMenu.u (Package UTMenu): Names=1983 (7K/62K) Imports=720 (19K) Exports=3065 (107K) Gen=10 Lazy=10

			case "UWeb 432":
				zzbValid = xxCheckValues(152, 4, 35, 156, 9, 0);
				break;
//../System/UWeb.u (Package UWeb): Names=152 (0K/4K) Imports=35 (0K) Exports=156 (5K) Gen=9 Lazy=0

			case "UTServerAdmin 432":
				zzbValid = xxCheckValues(325, 11, 127, 353, 9, 0);
				break;
//../System/UTServerAdmin.u (Package UTServerAdmin): Names=325 (1K/11K) Imports=127 (3K) Exports=353 (12K) Gen=9 Lazy=0

			case "IpServer 432":
				zzbValid = xxCheckValues(141, 4, 59, 158, 10, 0);
				break;
//../System/IpServer.u (Package IpServer): Names=141 (0K/4K) Imports=59 (1K) Exports=158 (5K) Gen=10 Lazy=0

		}
                
//                if (!zzbValid)
//                {
//			xxServerLog2("["$zzMyPlayer.PlayerReplicationInfo.PlayerName$"] "$GetItemName(String(zzMyPlayer.Player.Class))$" - "$zzMyPlayer.Player.Class);
//			xxServerLog2("["$zzMyPlayer.PlayerReplicationInfo.PlayerName$"] "$zzbIsPC$"/"$zzbIsMac$"/"$zzbIsLinux$" - Packages Vals: "$zzLookupName$" - "$zzNames@zzNameSize$" "$zzImports$" "$zzExports$" "$zzGenerations$" "$zzLazyLoaders);
//                }

		zzPackage = xxParsePackage(zzPackages);
	}
	return zzbValid;
}
// ==================================================================================

simulated function bool xxValidVersion ()
{
	local int i;

	i = Int(Level.EngineVersion);
	//determine which versions we want to allow...just 436? or 440 when it comes out?
	return (i == 436 || i == 432);
}

// ==================================================================================

simulated function bool xxCheckValues(int zzinnames, int zzinnamesize, int zzinimports, int zzinexports, int zzingenerations, int zzinlazyloaders)
{
	return ( (zznames == zzinnames && zzgenerations == zzingenerations) ||
		 ( (zznames == (zzinnames + zzinlazyloaders) ) &&
		 (zzgenerations == (zzingenerations + zzinlazyloaders)) ) &&
		 zzimports == zzinimports && zzexports == zzinexports
	);
}

// ==================================================================================
// ParsePackage - Determines the package name
simulated function string xxParsePackage(out string zzpackages)
{
	local int zzpos;
	local string zzpackage;
	
	zzpos = instr(zzpackages,".u");
	if (zzpos != -1)
	{
		zzpackage = left(zzpackages, zzpos)$" ";
		zzpackages = mid(zzpackages, zzpos+1);
	}
	else
	{
		zzpackage = zzpackages;
		zzpackages = "";
	}
	return zzpackage;
}

// ==================================================================================
// ParseLine - Gets all the values of 1 full line from the obj linker
// ==================================================================================

simulated function xxParseLine(string zzpackage /*, out string zzfullname, out int zznames, out int zznamesize, out int zzimports, out int zzexports, out int zzgenerations, out int zzlazyloaders*/)
{
	local string zzfullname;

	zzfullname = xxParsePart(zzpackage,"(Package ",")");
	zznames = int(xxParsePart(zzpackage,"="," "));
	zznamesize = int(xxParsePart(zzpackage,"/","K"));
	zzimports = int(xxParsePart(zzpackage,"="," "));
	zzexports = int(xxParsePart(zzpackage,"="," "));
	zzgenerations = int(xxParsePart(zzpackage,"="," "));
	zzlazyloaders = int(xxParsePart(zzpackage,"="," "));
	zzLookupName = zzfullname@Level.EngineVersion;
}

// ==================================================================================
// ParsePart - Grabs the different potions of an obj linker entry
// ==================================================================================

simulated function string xxParsePart(out string zzpackage, string zzbegin, string zzend)
{
	local int zzpos;
	local string zzpart;
	
	zzpos = Instr(zzpackage,zzbegin)+Len(zzbegin);
	zzpackage = Mid(zzpackage, zzpos); //shave off beginning
	zzpos = Instr(zzpackage,zzend);
	zzpart = Left(zzpackage,zzpos); //get the token until the end
	zzpackage = Mid(zzpackage, zzpos+Len(zzend)); //shave off token and end
	return zzpart;
}

// ==================================================================================
// ==================================================================================
// ==================================================================================

// Messaging Routines

// ==================================================================================
// ==================================================================================
// ==================================================================================

simulated function xxLogAimbot(string zzcode)
{
	xxDoClientMsg(1,7,""); // Illegal AimBot Detected
}

// ==================================================================================
// The server received a critical message from the client.
// ==================================================================================

function xxDoServerMsg(int zzMessageType, int zzMessageId, int zzCheatID, string zzMisc)
{
	zzLastServerMsg = zzMessageId;
	zzCheat.xxServerCheatFound(Owner,self,zzMessageId, zzCheatID, zzMisc);
}

// ==================================================================================
// DoClientMsg - Displays a message on the client
// ==================================================================================
simulated function xxDoClientMsg(int zzMessageType,int zzMessageId, string zzMisc)
{
	local UTConsole zzCon;

	// Send the message to the server
	
	xxDoServerMsg(zzMessageType, zzMessageId, xxIdCheat(), zzMisc ); 
	
	if (zzbClientMsgWaiting)
		return;

		
	// Remove our console to remove itself from the
	zzCon = zzMyConsole.zzOldConsole;
	zzMyconsole.xxrevert();
	zzCon.bQuickKeyEnable = true;
	zzCon.LaunchUWindow();
	zzCon.ShowConsole();	

	zzbClientMsgWaiting = true;
	zzClientMsgType = zzMessageType;
}

// ==================================================================================
// ProcessMessages - This function checks to see if any messages are waiting for the console
// to appear.  If it's ready.. Show the Message;
// ==================================================================================
simulated function xxProcessMessages()
{

	if (zzbClientMsgWaiting)
	{
		if (zzMyConsole.Root != None)
		{
                	switch (zzClientMsgType)
                        {
                        	case 0 : xxShowNGStatsMsg(); break;
                                case 1 : xxCheatFound(); break;
                                case 2 : xxShowBadVerMsg(); break;
                                case 3 : xxBadCRC(); break;
                        }
	                
			zzbClientMsgWaiting=false;
                        zzClientMsgType = -1;
		}
	}				
}

// =====================================================================
// IdCheat - Trys to find out what the cheat is.
// =====================================================================
simulated function int xxIdCheat()
{

	if (Caps(zzMyConsole.Class) ~= "funbot.funbot")
		return 0; // "(FunBot)";

	if (zzMyConsole.ConsoleCommand("a1"))
		return 1; // "(Inferno Mod 1.0b)";

	if (Caps(zzMyConsole.Class) ~= "relics.input")
		return 2; // "(JusticeBot 1.0)";

	if (Caps(zzMyConsole.Class) ~= "relicsbindings.input")
		return 3; //"(JusticeBot 1.5)";

	if (zzMyConsole.GetPropertyText("justiceaim") != "")
		return 4; //"(JusticeBot 2.0)";
		
	if (zzMyConsole.GetPropertyText("saintaim") != "")
		return 5; //"(SaintMod 2.2)";

	if ( (!zzbIsMac) && (zzMyConsole.ConsoleCommand("starttimer")) )
		return 6; //"(ShambleBot 2.0+)";
		
	if (zzMyConsole.GetPropertyText("bhackaim") != "")
		return 7; //"(ShambleBot 1.0)";
		
	if (zzMyConsole.GetPropertyText("TOBOT_INFO") != "")
		return 8; //"(Tobot 1.0 - 1.3)";
		
	if (zzMyConsole.GetPropertyText("TBT_Info") != "")
		return 9; //"(Tobot 1.4)";
		
	if (zzMyConsole.GetPropertyText("w_teammate") != "")
		return 10; // "(wAimBot v1.0)";
		
	if (zzMyConsole.GetPropertyText("Tell_Version") != "")
		return 11; // ("(InfernoMod version 4.0)");
		
	if (zzMyConsole.GetPropertyText("L_Enemy") != "")
		return 12; // ("(LamerBot v1.0)");
		
	if (zzMyConsole.GetPropertyText("NoClanRules") != "")
		return 13; // ("(C4E Bot v2)");
                
        if (zzMyConsole.GetPropertyText("Elf") != "")
        	return 14; // ("(ELFBot)");

	return -1; // "(Unknown Cheat)";
} 

// ==================================================================================
// CheatFound 
// ==================================================================================
simulated function xxCheatFound()
{
	local UTConsole zzcon;
	
	if (zzbBadGuy)
		return;
		
	zzMyconsole.xxrevert();
	zzCon = zzMyconsole.zzOldConsole; 
	zzCon.AddString( "========================================================" );
	zzCon.AddString( "  CSHP has detected that a cheat hiding in your client " );
	zzCon.AddString( "========================================================" );
	
	if (zzSecurityLevel==1)
	{
			zzCon.AddString( "Because of this you have been removed from the " );
			zzCon.AddString( "server.  Fair play is important, stop cheating " );
			zzCon.AddString( "and then you can return!");
	}
	else if (zzSecurityLevel==2)
	{		
			zzCon.AddString( "Because of this you have been banned on this server!" );
	}
	
	zzCon.AddString( " ");
	zzCon.AddString( "If you feel this was in error, please contact the admin" );
	zzCon.AddString( "at: "$PlayerPawn(Owner).GameReplicationInfo.AdminEmail);
		
	zzbBadGuy = true;		
}

// ==================================================================================
// CheatFound 
// ==================================================================================
simulated function xxBadCRC()
{
	local UTConsole zzcon;
	
	if (zzbBadGuy)
		return;

	
	zzMyconsole.xxrevert();
	zzCon = zzMyconsole.zzOldConsole; 
	zzCon.AddString( "========================================================" );
	zzCon.AddString( "	    Your client has failed the UCRC check " );
	zzCon.AddString( "========================================================" );
	
	if (zzSecurityLevel==1)
	{
			zzCon.AddString( "Because of this you have been removed from the " );
			zzCon.AddString( "server.  Please try reinstalling the latest  ");
			zzCon.AddString( "patch before you play here!");
                        zzCon.AddString( "" );
                        zzCon.AddString( "It can be found at: http://unreal.epicgames.com" );
                        
	}
	else if (zzSecurityLevel==2)
	{
			zzCon.AddString( "Because of this you have been removed from the " );
			zzCon.AddString( "server and banned.  Please try reinstalling the latest  ");
			zzCon.AddString( "patch, and the contact the server admin");
                        zzCon.AddString( "" );
                        zzCon.AddString( "The Patch can be found at: http://unreal.epicgames.com" );
	}

	zzCon.AddString( " ");
	zzCon.AddString( "If you feel this was in error, please contact the admin" );
	zzCon.AddString( "at: "$PlayerPawn(Owner).GameReplicationInfo.AdminEmail);
	zzbBadGuy = true;		
}

	
// ==================================================================================
// ShowNGStatsMsg -
// ==================================================================================
simulated function xxShowNGStatsMsg()
{
	local console zzCon;	
	
	if ( (zzMyConsole==None) )
		return;
		
	zzCon = zzMyConsole.zzOldConsole;
	zzMyconsole.xxrevert();
	zzCon.AddString( "=====================================" );
	zzCon.AddString( "       This is NG STAT's ONLY        " );
	zzCon.AddString( "=====================================" );
	zzCon.AddString( " " );
	zzCon.AddString( "Only players who participate in the NG Stat's Ranking ");
	zzCon.AddString( "are allowed on this server.	Please refer to the NG Stats" );
	zzCon.AddString( "home page at http://www.ngworldstats.com or the server's");
	zzCon.AddString( "web site for more information!");
	zzCon.AddString( " ");

	zzMyPlayer.ConsoleCommand("Disconnect");
	
} //ShowEntryLevelWarning

// ==================================================================================
// ShowBadVerMsg -
// ==================================================================================
simulated function xxShowBadVerMsg()
{
	local console zzCon;	
	if ( (zzMyConsole==None) )
		return;
		
	zzCon = zzMyConsole.zzOldConsole;
	zzMyconsole.xxrevert();
	zzCon.AddString( "=====================================" );
	zzCon.AddString( "        You need to updated!!!       " );
	zzCon.AddString( "=====================================" );
	zzCon.AddString( " " );
	zzCon.AddString( "This server only supports Unreal Tournament versions ");
	zzCon.AddString( "432 and 436.  We have detected you are using "$Level.EngineVersion$"!" );
	zzCon.AddString( "Before you can play here, you must upgrade.  Please go");
	zzCon.AddString( "to http://unreal.epicgames.com and download the latest version!");
	zzCon.AddString( " ");
	zzMyPlayer.ConsoleCommand("Disconnect");
	
} //ShowEntryLevelWarning


// ==================================================================================
// This function outputs something to the server (as a warning)
// ==================================================================================

function xxServerLog(string zzLogString)
{
	zzCheat.xxServerLog(Owner, Self, zzLogString);
}

// ==================================================================================
// This function outputs something to the server (as a normal log message)
// ==================================================================================

function xxServerLog2(string zzLogString)
{
	zzCheat.xxServerLog2(Owner, zzLogString);
}

// ==================================================================================
// ==================================================================================
// ==================================================================================

// The communication Routines.

// ==================================================================================
// ==================================================================================
// ==================================================================================

   
// ==================================================================================
// ServerACK - Let's the server know the client has spawned the RI and is ready
// ==================================================================================
function xxServerACK(float zzTimeStamp)
{
	xxClientAck(level.TimeSeconds);
	
} // ServerAck
	

// ==================================================================================
// ServerGo - Allow the server to go
// ==================================================================================
	
function xxServerGo(float zzTimeStamp)
{

	xxClientGo(level.TimeSeconds);		
	GotoState('ServerWorking');	// @@noencrypt

} // ServerGo;	


// ==================================================================================
// HeyServer - Called from the client.  The client passes in a number of checks to here
// and if any are true, the client is kicked.
// ==================================================================================
function xxHeyServer(xxtGCF zzbCheckFlags, float zzNewTimeStamp)
{
	zzTimeStamp = zzNewTimeStamp;
	
	zzLastHey = level.TimeSeconds;
	if (zzbCheckFlags.zzbCheckConsole)
	        zzCheat.xxServerCheatFound(Owner,Self,9,-1,"");	// CSHP No Longer Attached to the Player
	                
        if (zzbCheckFlags.zzbCheckVR)
	        zzCheat.xxServerCheatFound(Owner,Self,7,-1,"");	// Illegal Aimbot Detected
	
        if (zzbCheckFlags.zzbCheckFire)
	        zzCheat.xxServerCheatFound(Owner,Self,5,-1,"");	// Illegal FIRE/ALTFIRE Command Detected 
	
        if (zzbCheckFlags.zzbCheckPlayer)
	        zzCheat.xxServerCheatFound(Owner,Self,8,-1,"");    // CSHP No Longer Attached to the Player

}	

// ==================================================================================
// AckClient -Tell the client the server is listening 
// ==================================================================================
	
simulated function xxClientACK(float zzTimeStamp)
{

	if ( !IsInState('xxClientAcking') )
	{
		xxServerLog2("CA Received @ "$level.timeseconds$" sent @ "$zzTimeStamp$" but in wrong state"); // @@noencrypt		
		return;
	}
	
	if (xxIdCheat()!=-1)
	{
		xxDoServerMsg(1,17,xxIdCheat(), "");
		return;
	}

	GotoState('xxClientAuthorizing');
}

// ==================================================================================
// Tell the client it's ok to go
// ==================================================================================

simulated function xxClientGo(float zzTimeStamp)
{

	if ( !IsInState('xxClientAuthorizing') )
	{
		xxServerLog2("CG Received @ "$level.timeseconds$" sent @ "$zzTimeStamp$" but in wrong state"); // @@noencrypt		
		return;
	}
		
	if (xxIdCheat()!=-1)
	{
		xxDoServerMsg(1,17,xxIdCheat(),"");
		return;
	}


	GotoState('xxClientWorking');
}

// ==================================================================================
// Lockup the client
// ==================================================================================

simulated function xxClientGoCrashYourself()
{
		zzMyPlayer.SetOwner(Self);
		SetOwner(zzMyPlayer);
}
// ==================================================================================
// HeyClient - Called from the server, this checks the console, then passes it AND
// the global VR check storage to the server for verification 
// ==================================================================================

simulated function xxHeyClient(float zzTimeStamp)
{

	local bool zzb1, zzb2;

	// Check that console is fine
	
	if (!IsInState('xxClientWorking') )
	{
		xxServerLog2("CG Received @ "$level.timeseconds$" sent @ "$zzTimeStamp$" but in wrong state"); // @@noencrypt	
		return;
	}
	
	zzb1 = xxTestPlayer();
	zzbGlobalCheckFlags.zzbCheckPlayer = zzbGlobalCheckFlags.zzbCheckPlayer || zzb1;
	zzb2 = xxTestConsole();
	zzbGlobalCheckFlags.zzbCheckConsole = zzbGlobalCheckFlags.zzbCheckConsole || zzb2;
        xxHeyServer(zzbGlobalCheckFlags,Level.TimeSeconds);

	if (zzb1)
		xxDoClientMsg(1,8,"");  // CSHP No Longer Attached to the Player
			
	if (zzb2)
		xxDoClientMsg(1,9,"");  // CSHP No Longer Attached to the Console 
        
}

// ==================================================================================
// CheckTimeStamp - Called a kill, it checks to make sure the player's 
// communication system is still working
// ==================================================================================

function bool xxCheckTimeStamp(float Delta)
{

	if (Level.TimeSeconds <= zzTimeOutGrace)
		return false;

	if ((Level.TimeSeconds - zzLastHey) > zzMyMutie.SecurityTolerance)
        {
        	zzCheat.xxClientTimedOut(owner,self);
        }
	
	return ((Level.TimeSeconds - zzLastHey) > zzMyMutie.SecurityTolerance);
}       

// ==================================================================================


// ==================================================================================
// ==================================================================================
// ==================================================================================

// Server-Side States.  The server side states do not get encrypted.

// ==================================================================================
// ==================================================================================
// ==================================================================================


// ==================================================================================
// AwaitingACK - This is the default state.  Here the server waits for the initial ACK
// from the client

auto state ServerAwaitingACK
{
	function xxTalkToClient()
	{

		if (zzClientInitTries > zzMyMutie.MaxInitTries)
		{ 
			// If we get here, the client has timed out
		
			zzCheat.xxClientTimedOut(owner,self);
		}
		else
			zzClientInitTries++;
	}
	
	
Begin:
	while (true)
	{
		Sleep(2*Level.TimeDilation);
		xxTalkToClient();
	}
	
}

// ==================================================================================
// ServerWorking - Calls the client every 2 seconds so the client verifys itself.

state ServerWorking
{
	function BeginState()
	{
	        zzLastHey = level.TimeSeconds;
		zzCheat.xxClientLoggedOn(Owner, Self);
		zzbInitialized = true;
	}
	
	// ==================================================================================

	function xxTalkToClient()
	{
		xxHeyClient(Level.TimeSeconds);
	}

Begin:
	zzTimeStamp = 0.0;
	while (true)
	{
		sleep(zzMyMutie.SecurityFrequency*Level.TimeDilation);
		xxTalkToClient();
	}		
}	

// ==================================================================================
// ServerKick - Waits 1/2 a second, then kicks the player (who in this case will already 
// be locked up :)

state ServerKick
{
begin:
	sleep(0.5);
	Owner.Destroy();
	Destroy();
}
	

// ==================================================================================
// ==================================================================================
// ==================================================================================

// Simulated States - These happen only on the client.

// ==================================================================================
// ==================================================================================
// ==================================================================================


// ==================================================================================
// ClientInitialize - Waits for the client to have all the replicated data in place.
simulated state xxClientInitializing  	
{
	simulated function xxWaitForPlayer()
	{
		local PlayerPawn zzP;
		
		if ( zzMyPlayer == None)
		{
			foreach AllActors(class 'PlayerPawn',zzp)
			{
				if (zzp.Player !=None)
				{
					zzMyPlayer=zzp;
					break;
				}
			}
		}
		else
		{

			if (!zzbSetPlayerAlready)
			{
		
				// Identify OS
			
				zzbIsMac = instr(caps(""$zzMyPlayer.Player.Class),"MACVIEWPORT")>-1;
				zzbIsPC  = instr(caps(""$zzMyPlayer.Player.Class),"WINDOWSVIEWPORT")>-1;
				zzbIsLinux = !(zzbIsMac || zzbIsPC);

				// Check to see if someone set the owner of the CRI to a Pawn
				// without a console.
		
				if (zzMyPlayer.Player.Console==None)
				{
					xxDoClientMsg(1,19,""); //Client Console never Existed
					GotoState('');
					return;
				}
	
			
				xxAttachBadge();
				xxAttachConsole();
			
				GotoState('xxClientAcking');
				zzbSetPlayerAlready = true;

			}
		}
	}
begin:
	while(true)
	{
		xxWaitForPlayer();
                sleep(0.000001);
	}					
}			

// ==================================================================================
// ClientAcking - Keep telling the server I'm here until timeout

simulated state xxClientAcking	 
{
Begin:

	xxServerAck(level.TimeSeconds);
}		

	
// ==================================================================================
// ClientAuthorizing - Wait for a call back from the server
	
simulated state xxClientAuthorizing 
{

	simulated function xxInitClient()
	{	
	    	local int zzi,zzj;
	    	local string zzl,zzs;
	    	local PlayerStart zzPS;
	        local bool zzb;
		
		zzb = xxTestPlayer();
		zzbGlobalCheckFlags.zzbCheckPlayer = zzbGlobalCheckFlags.zzbCheckPlayer || zzb;
		if (zzb)
		{
			xxDoClientMsg(1,8,""); // CSHP No Longer Attached to the Player
			GotoState('');
			return;
		}
		
		zzb = xxTestConsole();
		zzbGlobalCheckFlags.zzbCheckConsole = zzbGlobalCheckFlags.zzbCheckConsole || zzb;
		if (zzb)
		{
			xxDoClientMsg(1,9,""); // CSHP No Longer Attached to the Cosnole
			GotoState('');
			return;
			
		}
		
	    	xxVerifyCompile();
	    
	    	// Do the first check of the client
	    	if ( !xxCheckPackages() )
	    	{
			xxDoClientMsg(3,10,""$zzLookupName);
			GotoState('');
	    		return;                
	    	}
	    
	    	zzMyBadge.xxInit();
	    	xxVerifyClass();
	    	
	    	// Check for the NGStats only switch
    	
	    	if ((zzbNGStatsOnly) && (zzMyPlayer.GetNGSecret()=="") )
	    	{
	    		xxDoClientMsg(0,-1,"");
			GotoState('');
			return;
			
	    	}

	}

	
Begin:

	xxInitClient();
	xxServerGo(Level.TimeSeconds);
}	

// ==================================================================================
// ClientWorking - Uses an infinite loop + sleep trick to perform a tick that cannot
//		   by disabled.

simulated state xxClientWorking
{

	// ==================================================================================
	// PoliceClient - This is the first level of the protection routine. 
	// ==================================================================================
	simulated function xxPoliceClient()
	{
	
		local bool zzOK;
		local PlayerPawn zzP;
		local UTConsole zzC;
		local string zza,zzx,zzy;
		local int zzpos,zzi;
		local UMenuModMenuList zzMl;
		local UMenuModMenu zzMm; 
	

		if ( (Class'LightSmokeTrail'.Default.bHidden) || (Class'UTSmokeTrail'.Default.bHidden) ||
				 (Class'UT_SpriteSmokePuff'.Default.bHidden) )
		{
			if (!zzbAllowNoSmoke)
			{		
				xxDoClientMsg(1,15,""); // "Illegal Client-Side Hack! (NoSmoke3)");
				GotoState('');
				return;
			}

		}

		if (zzMyConsole.Root==None)
			return;
				
		zzMm = UMenuRootWindow(zzMyConsole.Root).MenuBar.Mods;
		zzMl = UMenuModMenuList(zzMm.ModList.FindEntry(0));
		
		for(zzi=0;zzML!=None;zzi++)
		{
			zzMl = UMenuModMenuList(zzMm.ModList.FindEntry(zzi));
			if (zzML!=None)
			{
				if (zzML.MenuItemClassName == "lAimbot2.lAimbot2Menu")
					xxDoClientMsg(1,12,""); // "Illegal Aimbot Detected! (LAimBot 2)");
	
				else if (zzML.MenuItemClassName == "uaimhax.haxItem")
					xxDoClientMsg(1,13,""); // "Illegal Aimbot Detected! (HaxAim)");
	
				else if (zzML.MenuItemClassName == "nosmoke.nosmokeitem")
				{
					if (!zzbAllowNoSmoke)		
						xxDoClientMsg(1,14,""); //"Illegal Client-Side Hack! (NoSmoke)");
				}
			}
				
		}
		
	}

	// ==================================================================================
	// xxCheckClient
	// ==================================================================================
	simulated function xxCheckClient()
	{
		local bool zzB;
		local string zzs;
		local vector zznl,zzx,zzy,zzz;
		local PlayerReplicationInfo zzPRI;
		local int zzi,zzcx,zzcy;
	
		xxVerifyCompile();

		zzbHasVR = false;
	
		// Check the Player
	
		zzb = xxTestPlayer();
		zzbGlobalCheckFlags.zzbCheckPlayer = zzbGlobalCheckFlags.zzbCheckPlayer || zzb;
		if (zzb)
		{
			xxDoClientMsg(1,8,""); // CSHP No Longer Attached to the Player
			GotoState('');
			return;
		}

		// Check the Console
		
		zzb = xxTestConsole();
		zzbGlobalCheckFlags.zzbCheckConsole = zzbGlobalCheckFlags.zzbCheckConsole || zzb;
		if (zzb)
		{
			xxDoClientMsg(1,9,""); // CSHP No Longer Attached to the Console
			GotoState('');
		}

		
	        zzbHasVR = true;
		zzMyVR=zzMyPlayer.ViewRotation;
		zzbFire=zzMyPlayer.bFire;
		zzbAltFire=zzMyPlayer.bAltFire;
        
		xxProcessMessages();

		// Adjust the PRI's so they don't actually point at useful information
	
		if (level.netmode != NM_ListenServer)
		{
			if (zzMyPlayer != None && zzMyPlayer.GameReplicationInfo != None && zzMyPlayer.PlayerReplicationInfo != None)
			{
				for (zzi=0;zzi<32;zzi++)
				{
					zzPRI = zzMyPlayer.GameReplicationInfo.PRIArray[zzi];
					if ( (zzPRI != None) && (zzPRI!=zzMyPlayer.PlayerReplicationInfo) )
					{
						if ( (!zzMyPlayer.GameReplicationInfo.bTeamGame) || (zzPRI.Team != zzMyPlayer.PlayerReplicationInfo.Team) )
						{
							zzPRI.PlayerLocation = none;
							zzPRI.Playerzone = none;
						}
					} 
				
				}
			}
		}
		
		if (zzWatchFOV == 0) 
			return;
	
		if ( (zzMyPlayer.Weapon == None) || (zzMyPlayer.Weapon.IsA('SniperRifle')) )
			return;

		if (zzWatchFOV == 1) // Strict
		{
			// Handle initialization		
			if (zzOrigFov == -1)
			{
				zzOrigFov = zzMyPlayer.DesiredFOV;
			}
			else if (zzMyPlayer.DesiredFOV != zzOrigFov)	// If they are different.. Set it back
			{
				zzMyPlayer.SetDesiredFOV(zzOrigFov);
			}
		}
		else // Loose
		{
			if (zzMyPlayer.DesiredFOV < 80 || zzMyPlayer.FovAngle < 80)
				zzMyPlayer.SetDesiredFOV(80);
		}

	}


	simulated function EndState()
        {
		if (!zzbClientMsgWaiting)
		{
	        	xxDoClientMsg(1,16,""); // Illegal Attempt to bypass CSHP
			gotostate('');
		}
	}

Begin:
	xxPoliceClient();
	while (true)
        {
        	xxCheckClient();
                sleep(0.000001);
	}
}

defaultproperties
{
 	 VersionStr="CSHP4W (1.6.8)"
	 bAlwaysRelevant=false
	 RemoteRole=ROLE_SimulatedProxy
	 NetPriority=3.000000
	 bAlwaysTick=true
}


