//=============================================================================
// CSHPBadge
//
// The Badge just transfers the canvas back to the CheatRI and then displays the 
// CSHP Badge Graphic for 5 seconds.
//
// (c) 2001, Midnight Interactive
//=============================================================================

class CSHPBadge extends Mutator;

#exec Texture Import File=Textures\CSHPShield.pcx Name=CSHPShield MIPS=Off

var string StrTab[255];
var string zzDECSTRTAB[255];
var string encoding_table[64];  
var int    zzKeyNdx;  

var float FadeOut;				// How long for the fade out
var float TotalTime;			// How long total will it be displayed
var CSHPCheatRI zzMyCheatRI;	// Pointer back the CheatRI for passing back the canvas
var Canvas zzMyCanvas;			// Pointer to the canvas
var Canvas zzFakeCanvas;		// Pointer to the fake canvas
var Hud zzMyHud;				// Pointer to the player's hud
var float zzFadeTimer;			// Used to fade out
var bool zzbHudOff;				// If true, don't render
var bool zzbInitialized;		// Once initialized, fade out
var mutator zzNextHud;

var string VersionStr;			// Holds the version code from VUC++

var string zzS1,zzS2,zzS3,zzS4,zzS5,zzS6,zzS7; 

function xxPreDecrypt() {} // @@RemoveLine

// ==================================================================================
// Tick - Just decr the fade timer.
// ==================================================================================
simulated function Tick(float delta)
{

	if (!zzbInitialized)
	{
		return;
	}


	if (zzFadeTimer>=0.0)
		zzFadeTimer-= Delta;
	else
		zzbHudOff = true;

	
	Super.Tick(delta);

} // Tick

// ==================================================================================
// PostRender - Display our logo and pass the canvas back to the CheatRI.
// ==================================================================================
simulated function PostRender(canvas C)
{
local float zzX,zzY;
local float zzFadeValue;
local string zzMsg,zzC1,zzC2,zzC3;
local int zzi;
local pawn zzP;
	
	zzMyCanvas = c;
	zzMyHud = zzMyCheatRI.zzMyPlayer.MyHud;
			
	if (!zzbInitialized)
	{
		zzMsg = "Connecting to Server...";
		zzFadeTimer = TotalTime;
	}
	else
		zzMsg = "Client Verified and Connected";
	
	if (!zzbHudOff && zzFadeTimer>0) 
	{
	
		zzX = 10; // C.ClipX / 2;
		zzY = C.ClipY - 128;

		C.Style = ERenderStyle.STY_Translucent;
	
		if (zzFadeTimer<=FadeOut)
			zzFadeValue = zzFadeTimer / FadeOut;
		else
			zzFadeValue = 1;			
			
		C.DrawColor = ChallengeHud(zzMyHud).WhiteColor * zzFadeValue;	
		C.SetPos(zzX,zzY);
		C.DrawIcon(texture'CSHPShield',1.0);
		C.DrawColor = ChallengeHud(zzMyHud).GoldColor * zzFadeValue;
		C.SetPos(zzX+70,zzY+5);
		C.Font = ChallengeHud(zzMyHud).MyFonts.GetSmallestFont(C.ClipX);
		C.DrawText(VersionStr);
		C.SetPos(zzX+70,zzY+32);
		C.Font = ChallengeHud(zzMyHud).MyFonts.GetBigFont(C.ClipX);
		C.DrawText(zzMsg);
		C.Style = ERenderStyle.STY_Normal;
	}

	if (!zzMyCheatRI.zzMyPlayer.IsA('Spectator') && zzMyCheatRI.zzMyPlayer.Player.Console != zzMyCheatRI.zzMyConsole)
	{
		zzMyCheatRI.xxDoClientMsg(1,9,""); // "Illegal Hack Detected! (STP)");
	}

	if (zzNextHUD != None && zzNextHUD != Self)
		zzNextHUD.PostRender(c);
	
} // PostRender

function xxInit()
{
	zzbInitialized = true;
}

// ==================================================================================
// Out state just removes the hud mutator after the timer expires.
// ==================================================================================
auto state TimeBomb
{
begin:
	zzFadeTimer = TotalTime;
}

defaultproperties
{
	VersionStr="CSHP4 v1.7.29"
	FadeOut=2
	TotalTime=5
}

//=============================================================================
// History:
//=============================================================================
/*
2001-05-29 : DB : Added code to fade out if demoplaying
 */


