//=============================================================================
// ACEBan_Watcher.
//
// Made by CacoFFF (aka Higor)
// Contact me at caco_fff@hotmail.com
//=============================================================================
class ACEBan_Watcher expands Actor;

var ACEBan_HWID HWIDBan;
//var ACEBan_Other OtherComboBan;

var ACEBan_Watcher nextWatcher;
var IACECheck aceClient;

var int RemainChecks;
var string HWID;

auto state Watching
{
Begin:
	Sleep(1.0);
	if ( CheckPlayer() )
		RemainChecks = 59;
FindACE:
	Sleep(1.0);
	if ( RemainChecks-- <= 0 )
		Destroy();
	if ( CheckPlayer() )
	{
		if ( !FindACE() )
			Goto('FindACE');
	}

WaitForID:
	Sleep(1.0);
	if ( RemainChecks-- <= 0 )
		Destroy();
	if ( CheckPlayer() )
	{
		if ( !HasHWID() )
			Goto('WaitForId');
		else
			Goto('SimpleLoop');
	}

Ended:
	Destroy();

SimpleLoop:
	Sleep(1.0);
	if ( RemainChecks-- <= 0 )
		Destroy();
	Goto('SimpleLoop');
}

function bool CheckPlayer()
{
	if ( PlayerPawn(Owner) == none )
		Destroy();
	else
		return true;
	return false;
}

function bool FindACE()
{
	local IACECheck a;

	foreach allActors(class'IACECheck', a)
	{
		if (a.owner == owner)
		{
			aceClient = a;
			return true;
		}
	}
	return false;
}

function bool HasHWID()
{
	// Wine, in future version, switch to alternate ban method
	if ( aceClient == none )
	{
		if ( !FindACE() )
			return false;
	}
	if ( aceClient.bWine )
		return false;

	// Check if hardware GUID is available.
	if ( (HWID == "") && aceClient.hwHash != "")
	{
		HWID = aceClient.xxGetToken(aceClient.hwHash, ":", 1);
		if ( IsHWIDBanned() )
			HWIDBan.RemovePlayer( PlayerPawn(Owner) );
		return true;
	} 
	return false;
}

function bool IsHWIDBanned()
{
	if ( (HWID == "") || (HWID == "N/A") )
		return false;
	return HWIDBan.CheckHWIDBan( HWID);
}

//Linked list handling
event Destroyed()
{
	local ACEBan_Watcher p;

	if ( HWIDBan == none )
		return;

	if ( HWIDBan.watchList == self )
		HWIDBan.watchList = nextWatcher;
	else
	{
		For ( p=HWIDBan.watchList ; p!=none ; p=p.nextWatcher )
			if ( p.nextWatcher == self )
			{
				p.nextWatcher = nextWatcher;
				return;
			}
	}
}

defaultproperties
{
}
