//=============================================================================
// ACEBan_HWID.
//
// Mutator + config holder
//
// Made by CacoFFF (aka Higor)
// Contact me at caco_fff@hotmail.com
//=============================================================================
class ACEBan_HWID expands Mutator
	config (BanToolsACE);

var() config bool bTempIpBan;
var config string HWIDBan[512];

var ACEBan_Watcher watchList;
var bool bInitialized;

function bool CheckHWIDBan( string theID)
{
	local int i;

	For ( i=0 ; (i<512) && (HWIDBan[i]!="")  ; i++ )
		if ( HWIDBan[i] == theID )
			return true;
	return false;
}

function PostBeginPlay()
{
	Initialize();
}

function Initialize()
{
	if ( bInitialized)
		return;
	Spawn( class'ACEBan_SpNotify',none,'IdBanMutator').TheMutator = self; //Spawn notify to catch incoming playerpawns
	bInitialized = true;
}

function RemovePlayer( playerpawn P)
{
	local string Address;

	Address = P.GetPlayerNetworkAddress();
	if ( instr(Address, ":") > 4 )
		Address = Left( Address, instr(Address, ":") );

	if ( bTempIpBan && (Len(Address) > 5) )
	{
		Level.Game.IPPolicies[1] = "DENY,"$Address;
		BroadcastMessage( "HWID BAN: Added illegal ip to temporary ban list: "$Address, true );
	}
	P.Destroy();
}

defaultproperties
{
     bTempIpBan=True
}
