// =============================================================================
// AntiCheatEngine BETA 0.8 - (c) 2009-2010 AnthraX
//
// Modified version: - Logging Nexgen IDs
//                   ~ By Sp0ngeb0b NOV 2010
// =============================================================================
class ACEEventActor extends IACEEventHandler
    config(System);

    var NexgenController NSC;  // The NexgenController installed on server

// =============================================================================
// PostBeginPlay
// =============================================================================
function PostBeginPlay()
{
    ACEPadLog("","-","+",40,true);
    ACEPadLog("ACE EventHandler"," ","|",40,true);
    ACEPadLog("BETA "$ACEVersion," ","|",40,true);
    ACEPadLog("(c) 2009-2010 - AnthraX"," ","|",40,true);
    ACEPadLog("","-","+",40,true);
    SetTimer(1.0, true);
}

// =============================================================================
// Timer ~ Wait for main actor to spawn, then register
// =============================================================================
function Timer()
{
    local IACEActor A;

    Super.Timer();

    if (ConfigActor == none)
    {
        foreach Level.AllActors(class'IACEActor', A)
        {
            A.RegisterEventHandler(self);
            ConfigActor = A;
            break;
        }
    }
}

// =============================================================================
// ACELogExternal ~ Overridden
// =============================================================================
function ACELogExternal(string LogString)
{
    if (ConfigActor != none && ConfigActor.bExternalLog)
    {
        if (Logger == none)
        {
            Logger = Level.Spawn(class'IACELogger');
            Logger.OpenACELog(ConfigActor.JoinLogPath, ConfigActor.JoinLogPrefix, "");
            SetTimer(0.25, true);
        }

        if (Logger != none)
        {
            Logger.ACELog(LogString);
        }
    }
}

// =============================================================================
// ACEPlayerLog ~ Log player information
// =============================================================================
function ACEPlayerLog(string LogString, PlayerPawn Player)
{
    ACELog("["$Player.PlayerReplicationInfo.PlayerName$"]: "$LogString, ConfigActor.bExternalLogJoins);
}

// =============================================================================
// EventCatcher ~ Main event catcher function
// =============================================================================
function EventCatcher(name EventType, IACECheck Check, string EventData)
{
    switch(EventType)
    {
        case 'PlayerJoin':
            PlayerJoin(Check, EventData);
            break;
        case 'InitUnexpectedData':
            PlayerUnexpectedData(EventType, Check, EventData);
            break;
        case 'InitUnexpectedPackage':
            PlayerUnexpectedPackage(EventType, Check, EventData);
            break;
        case 'InitIllegalPackage':
            PlayerIllegalPackage(EventType, Check, EventData);
            break;
        case 'InitUnexpectedLibrary':
            PlayerUnexpectedLibrary(EventType, Check, EventData);
            break;
        case 'InitIllegalLibrary':
        case 'IllegalLibrary':
            PlayerIllegalLibrary(EventType, Check, EventData);
            break;
        case 'InitCorruptedFile':
            PlayerCorruptedFile(EventType, Check, EventData);
            break;
        case 'InitTimeOut':
            PlayerInitTimeOut(EventType, Check, EventData);
            break;
        case 'InternalError':
            PlayerInternalError(EventType, Check, EventData);
            break;
        case 'InternalErrorExtra':
            PlayerInternalErrorExtra(EventType, Check, EventData);
            break;
        case 'TimeOut':
            PlayerTimeOut(EventType, Check, EventData);
            break;
        case 'HookedModule':
            PlayerHookedModule(EventType, Check, EventData);
            break;
        case 'HookedModuleExtra':
            PlayerHookedModuleExtra(EventType, Check, EventData);
            break;
        case 'HookedPackage':
            PlayerHookedPackage(EventType, Check, EventData);
            break;
        case 'HookedPackageExtra':
            PlayerHookedPackageExtra(EventType, Check, EventData);
            break;
        case 'IllegalUFunctionCall':
            PlayerIllegalUFunctionCall(EventType, Check, EventData);
            break;
        case 'IllegalUFunctionCallExtra':
            PlayerIllegalUFunctionCallExtra(EventType, Check, EventData);
            break;
        case 'VTableHook':
            PlayerVTableHook(EventType, Check, EventData);
            break;
        case 'VTableHookExtra':
            PlayerVTableHookExtra(EventType, Check, EventData);
            break;
        case 'GNatHook':
            PlayerGNatHook(EventType, Check, EventData);
            break;
        case 'GNatHookExtra':
            PlayerGNatHookExtra(EventType, Check, EventData);
            break;
        case 'SShotStarted':
            PlayerSShotStarted(EventType, Check);
            break;
        case 'SShotEnded':
            PlayerSShotEnded(EventType, Check, EventData);
            break;
        case 'Incompatibility':
            PlayerIncompatibility(EventType, Check, EventData);
            break;
    }
}

// =============================================================================
// LogPlayerKick ~ Logs the header of a player kick
// =============================================================================
function LogPlayerKick(name KickEventType, string KickReason, IACECheck Check)
{
    local string CommandLine;
    local string HWID;

    if (Check.UTCommandLine == "")
        CommandLine = "<none>";
    else
        CommandLine = Check.UTCommandLine;

    if (Check.bWine)
        HWID = "N/A";
    else
        HWID = xxGetToken(Check.HWHash, ":", 1);

    // Log Header
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACEPadLog("Player Kick", " ", "|", 65, true, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Log Standard Info
    Check.ACELog("PlayerName...:" @ Check.PlayerName);
    Check.ACELog("PlayerIP.....:" @ Check.PlayerIP);
    Check.ACELog("NexgenID.....:" @ getNexgenID(PlayerPawn(Check.Owner)) );
    Check.ACELog("OS...........:" @ Check.OSString);
    if (Check.bWine)
    Check.ACELog("Wine.........:" @ Check.bWine);
    Check.ACELog("CPU..........:" @ Check.CPUIdentifier);
    Check.ACELog("CPUSpeed.....:" @ Check.CPUMeasuredSpeed
        $ " Mhz Measured - " $ Check.CPUReportedSpeed $ " Mhz Reported");
    Check.ACELog("NICDesc......:" @ Check.NICName);
    Check.ACELog("MACHash1.....:" @ Check.UTDCMacHash);
    Check.ACELog("MACHash2.....:" @ Check.MACHash);
    Check.ACELog("HWID.........:" @ HWID);
    Check.ACELog("UTVersion....:" @ Check.UTVersion);
    Check.ACELog("Renderer.....:" @ Check.RenderDeviceClass);
    Check.ACELog("SoundDevice..:" @ Check.SoundDeviceClass);
    Check.ACELog("CommandLine..:" @ CommandLine);

    // Log Kick Reason
    Check.ACELog("KickReason...:" @ KickReason);
    Check.ACELog("TimeStamp....:" @ GetDate() $ " / " $ GetTime());

    // End of standard log
    Check.ACEPadLog("", "-", "+", 65, false, true);
}

// =============================================================================
// PlayerJoin ~ Called when a player has successfully joined and spawned the
// native object
// =============================================================================
function PlayerJoin(IACECheck Check, optional string EventData)
{
    local string CommandLine;
    local PlayerPawn Player;
    local string HWID;

    Player = PlayerPawn(Check.Owner);

    if (Check.UTCommandLine == "")
        CommandLine = "<none>";
    else
        CommandLine = Check.UTCommandLine;

    if (Check.bWine)
        HWID = "N/A";
    else
        HWID = xxGetToken(Check.HWHash, ":", 1);

    ACEPlayerLog("[IP]"    @ Check.PlayerIP      , Player);
    ACEPlayerLog("[NSCID]" @ getNexgenID(Player), Player );
    ACEPlayerLog("[OS]"    @ Check.OSString      , Player);
    if (Check.bWine)
    ACEPlayerLog("[WINE]"  @ true                , Player);
    ACEPlayerLog("[CPU]"   @ Check.CPUIdentifier , Player);
    ACEPlayerLog("[CPUSPEED] Measured: " $
        Check.CPUMeasuredSpeed $ " Mhz - Reported: " $
        Check.CPUReportedSpeed $ " Mhz"          , Player);
    ACEPlayerLog("[NIC]"   @ Check.NICName       , Player);
    ACEPlayerLog("[MAC1]"  @ Check.UTDCMacHash   , Player);
    ACEPlayerLog("[MAC2]"  @ Check.MACHash       , Player);
    ACEPlayerLog("[HWID]"  @ HWID                , Player);
    ACEPlayerLog("[UTVER]" @ Check.UTVersion     , Player);
    ACEPlayerLog("[UTCMD]" @ CommandLine         , Player);
    ACEPlayerLog("[RENDEV]" @ Check.RenderDeviceClass , Player);
    ACEPlayerLog("[SNDDEV]" @ Check.SoundDeviceClass  , Player);
    ACEPlayerLog("[TIME]" @ GetDate() $ " / " $ GetTime(), Player);
}

// =============================================================================
// PlayerUnexpectedData ~ Unexpected Data was received from the client
// Should NEVER happen!
// =============================================================================
function PlayerUnexpectedData(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Unexpected data received", Check);

    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("Data.........:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    Check.KickReason[0] = "You have been kicked from the server because your client sent unexpected data";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerUnexpectedPackage ~ An unexpected package has been found during the initial check
// Should NEVER happen!
// =============================================================================
function PlayerUnexpectedPackage(name EventType, IACECheck Check, string EventData)
{
    local string PackageName;
    local string PackagePath;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Unexpected package found during initial check", Check);

    // Parse Event Data
    PackageName    = xxGetToken(EventData, ":::", 0);
    PackagePath    = xxGetToken(EventData, ":::", 1);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("PackageName..:" @ PackageName);
    Check.ACELog("PackagePath..:" @ PackagePath);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because an unexpected package has been found";
    Check.KickReason[1] = "Package = " @ PackageName $ " ( " $ PackagePath $ " )";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerIllegalPackage ~ An illegal package has been found during the initial check
// =============================================================================
function PlayerIllegalPackage(name EventType, IACECheck Check, string EventData)
{
    local string PackageName;
    local string PackagePath;
    local int    PackageSize;
    local string PackageHash;
    local string PackageVersion;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Illegal package found during initial check", Check);

    // Parse Event Data
    PackageName    = xxGetToken(EventData, ":::", 0);
    PackagePath    = xxGetToken(EventData, ":::", 1);
    PackageSize    = int(xxGetToken(EventData, ":::", 2));
    PackageHash    = xxGetToken(EventData, ":::", 3);
    PackageVersion = xxGetToken(EventData, ":::", 4);

    if (PackageVersion == "")
        PackageVersion = "Unknown Package";

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("PackageName..:" @ PackageName);
    Check.ACELog("PackagePath..:" @ PackagePath);
    Check.ACELog("PackageSize..:" @ PackageSize @ "bytes");
    Check.ACELog("PackageHash..:" @ PackageHash);
    Check.ACELog("PackageVer...:" @ PackageVersion);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    if (PackageSize == 0)
    {
        Check.KickReason[0] = "You have been kicked from the server because the following file is missing:";
        Check.KickReason[1] = "File = " @ PackageName;
        Check.KickReason[2] = "Please reinstall this file and then come back.";
        Check.KickReason[3] = "Patch Mirrors can be found at: http://downloads.unrealadmin.org/";
    }
    else
    {
        Check.KickReason[0] = "You have been kicked from the server because the following file is unknown:";
        Check.KickReason[1] = "File = " @ PackageName $ " ( " $ PackagePath $ " )";
        Check.KickReason[2] = "Please reinstall the original file and then come back.";
        Check.KickReason[3] = "Patch Mirrors can be found at: http://downloads.unrealadmin.org/";
    }

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerMessage(Check.KickReason[2]);
    Check.PlayerMessage(Check.KickReason[3]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerUnexpectedLibrary ~ An unexpected library has been found during the initial check
// Should NEVER happen!
// =============================================================================
function PlayerUnexpectedLibrary(name EventType, IACECheck Check, string EventData)
{
    local string LibraryName;
    local string LibraryPath;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Unexpected library found during initial check", Check);

    // Parse Event Data
    LibraryName    = xxGetToken(EventData, ":::", 0);
    LibraryPath    = xxGetToken(EventData, ":::", 1);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("LibraryName..:" @ LibraryName);
    Check.ACELog("LibraryPath..:" @ LibraryPath);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because an unexpected library has been found";
    Check.KickReason[1] = "Library = " @ LibraryName $ " ( " $ LibraryPath $ " )";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerIllegalLibrary ~ An illegal library has been found during the initial check
// =============================================================================
function PlayerIllegalLibrary(name EventType, IACECheck Check, string EventData)
{
    local string LibraryName;
    local string LibraryPath;
    local int    LibrarySize;
    local string LibraryHash;
    local string LibraryVersion;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Illegal library found", Check);

    // Parse Event Data
    LibraryName    = xxGetToken(EventData, ":::", 0);
    LibraryPath    = xxGetToken(EventData, ":::", 1);
    LibrarySize    = int(xxGetToken(EventData, ":::", 2));
    LibraryHash    = xxGetToken(EventData, ":::", 3);
    LibraryVersion = xxGetToken(EventData, ":::", 4);

    if (LibraryVersion == "")
        LibraryVersion = "Unknown File";

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("LibraryName..:" @ LibraryName);
    Check.ACELog("LibraryPath..:" @ LibraryPath);
    Check.ACELog("LibrarySize..:" @ LibrarySize @ "bytes");
    Check.ACELog("LibraryHash..:" @ LibraryHash);
    Check.ACELog("LibraryVer...:" @ LibraryVersion);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    if (LibrarySize == 0)
    {
        Check.KickReason[0] = "You have been kicked from the server because the following file is missing:";
        Check.KickReason[1] = "File = " @ LibraryName;
        Check.KickReason[2] = "Please reinstall this file and then come back.";
        Check.KickReason[3] = "Patch Mirrors can be found at: http://downloads.unrealadmin.org/";
    }
    else
    {
        Check.KickReason[0] = "You have been kicked from the server because the following file is unknown:";
        Check.KickReason[1] = "File = " @ LibraryName $ " ( " $ LibraryPath $ " )";
        Check.KickReason[2] = "Please reinstall the original file and then come back.";
        Check.KickReason[3] = "Patch Mirrors can be found at: http://downloads.unrealadmin.org/";
    }

    if (LibraryName ~= "UnrealTournament.exe")
    {
        Check.KickReason[4] = "Keep in mind that you do NOT need a dual-core fix to play on ACE servers.";
    }

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerMessage(Check.KickReason[2]);
    Check.PlayerMessage(Check.KickReason[3]);
    if (LibraryName ~= "UnrealTournament.exe")
        Check.PlayerMessage(Check.KickReason[4]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerCorruptedFile ~ Corrupted file during initial check
// =============================================================================
function PlayerCorruptedFile(name EventType, IACECheck Check, string EventData)
{
    local string FileName;
    local string FilePath;
    local int    FileSize;
    local string FileHash;
    local string FileError;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Corrupted file found during initial check", Check);

    // Parse Event Data
    FileName    = xxGetToken(EventData, ":::", 0);
    FilePath    = xxGetToken(EventData, ":::", 1);
    FileSize    = int(xxGetToken(EventData, ":::", 2));
    FileHash    = xxGetToken(EventData, ":::", 3);
    FileError   = xxGetToken(EventData, ":::", 4);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("FileName.....:" @ FileName);
    Check.ACELog("FilePath.....:" @ FilePath);
    Check.ACELog("FileSize.....:" @ FileSize @ "bytes");
    Check.ACELog("FileHash.....:" @ FileHash);
    Check.ACELog("FileError....:" @ FileError);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because a corrupted file has been found";
    Check.KickReason[1] = "File = " @ FileName $ " ( " $ FilePath $ " )";
    Check.KickReason[2] = "Please reinstall this file and then come back.";
    Check.KickReason[3] = "Patch Mirrors can be found at: http://downloads.unrealadmin.org/";

    if (FileName ~= "UnrealTournament.exe")
    {
        Check.KickReason[4] = "Keep in mind that you do NOT need a dual-core fix to play on ACE servers.";
    }

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerMessage(Check.KickReason[2]);
    Check.PlayerMessage(Check.KickReason[3]);
    if (FileName ~= "UnrealTournament.exe")
        Check.PlayerMessage(Check.KickReason[4]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerInitTimeout - Timeout during the initial check
// =============================================================================
function PlayerInitTimeout(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Timeout during initial check", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("FileName.....:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because of a timeout during the initial check";
    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerInternalError - Internal error while processing check feedback
// Most likely cause is someone tampering with the ACE module
// =============================================================================
function PlayerInternalError(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Internal Error", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("ErrorType....:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because ACE has encountered an internal error.";
    Check.KickReason[1] = "Try to restart your game and then rejoin the server.";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerInternalErrorExtra - In rare cases extra info MIGHT follow
// =============================================================================
function PlayerInternalErrorExtra(name EventType, IACECheck Check, string EventData)
{
    if (xxGetToken(EventData, ":::", 0) == "DBG")
    {
        Check.ACELog("HookAddr.....:" @ xxGetToken(EventData, ":::", 1));
        Check.ACELog("HookFunc.....:" @ xxGetToken(EventData, ":::", 2));
        if (xxGetToken(EventData, ":::", 3) != "")
        Check.ACELog("HookModule...:" @ xxGetToken(EventData, ":::", 3));
        Check.ACEPadLog("", "-", "+", 65, false, true);
    }
}

// =============================================================================
// PlayerTimeOut - Timeout during the periodic check
// =============================================================================
function PlayerTimeOut(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Timeout during checks", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    if (Left(EventData, 3) == ":::")
        Check.ACELog("Check........:" @ Mid(EventData, 3));
    else
        Check.ACELog("FileName.....:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because of a timeout during the checks";
    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerHookedModule ~ A hooked module means:
// * The disk version of the module (dll) was legit
// * The disk version was not mapped correctly into the memory
// OR
//   The memory version of the module was illegaly altered
// =============================================================================
function PlayerHookedModule(name EventType, IACECheck Check, string EventData)
{
    local string LibraryAddress;
    local string LibraryName;
    local string LibraryPath;
    local string LibraryHash;
    local int    LibrarySize;
    local string LibraryVersion;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Hooked Module", Check);

    // Parse Event Data
    LibraryAddress = xxGetToken(EventData, ":::", 0);
    LibraryName    = xxGetToken(EventData, ":::", 1);
    LibraryPath    = xxGetToken(EventData, ":::", 2);
    LibraryHash    = xxGetToken(EventData, ":::", 3);
    LibrarySize    = int(xxGetToken(EventData, ":::", 4));
    LibraryVersion = xxGetToken(EventData, ":::", 5);

    if (LibraryVersion == "")
        LibraryVersion = "Unknown File";

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("BaseAddress..:" @ LibraryAddress);
    Check.ACELog("LibraryName..:" @ LibraryName);
    Check.ACELog("LibraryPath..:" @ LibraryPath);
    Check.ACELog("LibrarySize..:" @ LibrarySize @ "bytes");
    Check.ACELog("LibraryHash..:" @ LibraryHash);
    Check.ACELog("LibraryVer...:" @ LibraryVersion);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    // The actual hook description follows through PlayerHookedModuleExtra calls
    Check.ACEPadLog("Hook Description", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked from the server because a hook has been found";
    Check.KickReason[1] = "Hooked module: " $ LibraryPath;

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerHookedModuleExtra ~ Logs detailed information about a hook kick
// =============================================================================
function PlayerHookedModuleExtra(name EventType, IACECheck Check, string EventData)
{
    local int HookType;
    local string Temp;
    local bool bINTMismatch;

    HookType = int(xxGetToken(EventData, ":::", 0));

    switch (HookType)
    {
        case 1:
            Check.ACELog("HookType.....:" @ "CODE");
            Check.ACELog("HookFunction.:" @ xxGetToken(EventData, ":::", 1));
            Check.ACELog("HookThunk....:" @ xxGetToken(EventData, ":::", 2));
            Check.ACELog("HookOffset...:" @ xxGetToken(EventData, ":::", 3));
            Check.ACELog("HookDesc.....:" @ xxGetToken(EventData, ":::", 4));

            if (Check.KickReason[2] == "")
            {
                if (InStr(CAPS(xxGetToken(EventData, ":::", 4)), "UTDCPLUS") != -1)
                {
                    Check.KickReason[2] = "This kick might be caused by UTDCPlus.";
                    Check.KickReason[3] = "Try to restart your game and then rejoin the server.";
                }
                else if (InStr(CAPS(xxGetToken(EventData, ":::", 4)), "GNAT") != -1)
                {
                    Check.KickReason[2] = "This kick might be caused by GNAT.";
                    Check.KickReason[3] = "Try to restart your game and then rejoin the server.";
                }
            }
            break;

        case 2:

            Temp = xxGetToken(EventData, ":::", 7);
            if (Temp ~= "o" || Temp ~= "n") bINTMismatch = true;

            if (bINTMismatch)
            {
                Check.ACELog("HookType.....:" @ "INT");
                Check.ACELog("ImportNum....:" @ xxGetToken(EventData, ":::", 1));
                Check.ACELog("Expected.....:" @ xxGetToken(EventData, ":::", 3) $ "!" $ xxGetToken(EventData, ":::", 4) $ ":" $ xxGetToken(EventData, ":::", 5));
                Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 6) $ " -> " $ xxGetToken(EventData, ":::", 7) $ ":" $ xxGetToken(EventData, ":::", 8));
            }
            else
            {
                Check.ACELog("HookType.....:" @ "IAT");
                Check.ACELog("ImportNum....:" @ xxGetToken(EventData, ":::", 1));
                Check.ACELog("Expected.....:" @ xxGetToken(EventData, ":::", 2) $ " -> " $ xxGetToken(EventData, ":::", 3) $ "!" $ xxGetToken(EventData, ":::", 4) $ ":" $ xxGetToken(EventData, ":::", 5));
                Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 6) $ " -> " $ xxGetToken(EventData, ":::", 7) $ "!" $ xxGetToken(EventData, ":::", 8) $ "+" $ xxGetToken(EventData, ":::", 9));
            }

            break;

        case 3:
            Check.ACELog("HookType.....:" @ "EAT");
            Check.ACELog("Expected.....:" @ xxGetToken(EventData, ":::", 2) $ " -> " $ xxGetToken(EventData, ":::", 1));
            Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 3) $ " -> " $ xxGetToken(EventData, ":::", 4) $ "!" $ xxGetToken(EventData, ":::", 5) $ "+" $ xxGetToken(EventData, ":::", 6));
            break;
    }

    Check.ACEPadLog("", "-", "+", 65, false, true);
}

// =============================================================================
// PlayerHookedPackage ~ The disk version of the package is legal but it wasn't
// mapped into the memory correctly!
// =============================================================================
function PlayerHookedPackage(name EventType, IACECheck Check, string EventData)
{
    local string PackageName;
    local string PackagePath;
    local string PackageHash;
    local string PackageSize;
    local string PackageVersion;

    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Hooked Package", Check);

    // Parse Event Data
    PackageName    = xxGetToken(EventData, ":::", 0);
    PackagePath    = xxGetToken(EventData, ":::", 1);
    PackageHash    = xxGetToken(EventData, ":::", 2);
    PackageSize    = xxGetToken(EventData, ":::", 3);
    PackageVersion = xxGetToken(EventData, ":::", 4);

    if (PackageVersion == "")
        PackageVersion = "Unknown Package";

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("PackageName..:" @ PackageName);
    Check.ACELog("PackagePath..:" @ PackagePath);
    Check.ACELog("PackageSize..:" @ PackageSize @ "bytes");
    Check.ACELog("PackageHash..:" @ PackageHash);
    Check.ACELog("PackageVer...:" @ PackageVersion);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    // The actual hook description follows through PlayerHookedModuleExtra calls
    Check.ACEPadLog("Hook Description", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked for an impurity - Code 0x00";
    Check.KickReason[1] = "Try to restart your game and then rejoin the server.";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerHookedPackageExtra ~ Extra information
// =============================================================================
function PlayerHookedPackageExtra(name EventType, IACECheck Check, string EventData)
{
    local string HookType;
    local int    EntryNum;

    HookType = xxGetToken(EventData, ":::", 0);
    EntryNum = int(xxGetToken(EventData, ":::", 1));

    Check.ACELog("HookType.....:" @ HookType);
    Check.ACELog("HookEntry....:" @ EntryNum);

    if (HookType == "FH")
    {
        Check.ACELog("HookFunc.....:" @ xxGetToken(EventData, ":::", 2));
        Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 3) $ " -> " $ xxGetToken(EventData, ":::", 4) $ "!" $ xxGetToken(EventData, ":::", 5) $ "+" $ xxGetToken(EventData, ":::", 6));
    }
    else if (HookType == "SE")
    {
        Check.ACELog("HookFunc.....:" @ xxGetToken(EventData, ":::", 2));
        Check.ACELog("HookChecksum.:" @ xxGetToken(EventData, ":::", 3));
    }
    else
    {
        Check.ACELog("Expected.....:" @ xxGetToken(EventData, ":::", 2));
        Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 3));
    }

    Check.ACEPadLog("", "-", "+", 65, false, true);
}

// =============================================================================
// PlayerIllegalUFunctionCall ~ Illegal UScript Function Call
// =============================================================================
function PlayerIllegalUFunctionCall(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Illegal UFunction Call", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("FunctionName.:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACEPadLog("Call Graph", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked for an illegal ufunction call.";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerIllegalUFunctionCallExtra ~ Extra Information for an illegal UFunction
// Call
// =============================================================================
function PlayerIllegalUFunctionCallExtra(name EventType, IACECheck Check, string EventData)
{
    local int i;
    local int CalleeLevel;
    local string CalleeName;
    local string Temp;

    if (EventData != "")
    {
        CalleeLevel = int(xxGetToken(EventData, ":::", 0));
        CalleeName  = xxGetToken(EventData, ":::", 1);

        Temp = "Callee"$CalleeLevel;
        while (Len(Temp) < 13) Temp = Temp $ ".";
        Temp = Temp $ ":";

        Check.ACELog(Temp @ CalleeName);
    }
    else
    {
        Check.ACEPadLog("", "-", "+", 65, false, true);
    }
}

// =============================================================================
// PlayerVTableHook ~ Virtual Function Table Hook
// Detailed information follows in subsequent PlayerVTableHookExtra calls
// =============================================================================
function PlayerVTableHook(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "VTable Hook", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked for an impurity - Code 0x01";
    Check.KickReason[1] = "Try to restart your game and then rejoin the server.";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerVTableHookExtra ~
// =============================================================================
function PlayerVTableHookExtra(name EventType, IACECheck Check, string EventData)
{
    Check.ACELog("ModuleHandle.:" @ xxGetToken(EventData, ":::", 2));
    Check.ACELog("ModuleName...:" @ xxGetToken(EventData, ":::", 3));
    Check.ACELog("HookedObject.:" @ xxGetToken(EventData, ":::", 1));
    Check.ACELog("HookedEntry..:" @ xxGetToken(EventData, ":::", 0));
    Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 4)
        $ " -> " $ xxGetToken(EventData, ":::", 5)
        $ "!" $ xxGetToken(EventData, ":::", 6)
        $ "+" $ xxGetToken(EventData, ":::", 7));

    Check.ACEPadLog("", "-", "+", 65, false, true);
}

// =============================================================================
// PlayerGNatHook ~ GNativesHook
// =============================================================================
function PlayerGNatHook(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "GNatives Hook", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked for an impurity - Code 0x02";
    Check.KickReason[1] = "Try to restart your game and then rejoin the server.";

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerKick(true);
}

// =============================================================================
// PlayerGNatHookExtra ~
// =============================================================================
function PlayerGNatHookExtra(name EventType, IACECheck Check, string EventData)
{
    Check.ACELog("HookedEntry..:" @ xxGetToken(EventData, ":::", 0));
    Check.ACELog("Found........:" @ xxGetToken(EventData, ":::", 1)
        $ " -> " $ xxGetToken(EventData, ":::", 2)
        $ "!" $ xxGetToken(EventData, ":::", 3)
        $ "+" $ xxGetToken(EventData, ":::", 4));

    Check.ACEPadLog("", "-", "+", 65, false, true);
}

// =============================================================================
// PlayerSShotStarted ~ A Screenshot is being created on demand
// =============================================================================
function PlayerSShotStarted(name EventType, IACECheck Check)
{
    local string CommandLine;
    local string HWID;

    if (Check.UTCommandLine == "")
        CommandLine = "<none>";
    else
        CommandLine = Check.UTCommandLine;

    if (Check.bWine)
        HWID = xxGetToken(Check.HWHash, ":", 0);
    else
        HWID = xxGetToken(Check.HWHash, ":", 1);

    // Log Header
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACEPadLog("Player Screenshot", " ", "|", 65, true, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Log Standard Info
    Check.ACELog("PlayerName...:" @ Check.PlayerName);
    Check.ACELog("PlayerIP.....:" @ Check.PlayerIP);
    Check.ACELog("NexgenID.....:" @ getNexgenID(PlayerPawn(Check.Owner)) );
    Check.ACELog("OS...........:" @ Check.OSString);
    if (Check.bWine)
    Check.ACELog("Wine.........:" @ Check.bWine);
    Check.ACELog("CPU..........:" @ Check.CPUIdentifier);
    Check.ACELog("CPUSpeed.....:" @ Check.CPUMeasuredSpeed
        $ " Mhz Measured - " $ Check.CPUReportedSpeed $ " Mhz Reported");
    Check.ACELog("MACHash1.....:" @ Check.UTDCMacHash);
    Check.ACELog("MACHash2.....:" @ Check.MACHash);
    Check.ACELog("HWID.........:" @ HWID);
    Check.ACELog("UTVersion....:" @ Check.UTVersion);
    Check.ACELog("Renderer.....:" @ Check.RenderDeviceClass);
    Check.ACELog("SoundDevice..:" @ Check.SoundDeviceClass);
    Check.ACELog("CommandLine..:" @ CommandLine);

    // Log SShot Requester
    Check.ACELog("RequestedBy..:" @ Check.SShotRequester @ "(" $ Check.SShotRequester.PlayerReplicationInfo.PlayerName $ ")");
    Check.ACELog("TimeStamp....:" @ GetDate() $ " / " $ GetTime());

    // End of standard log
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Notify Requester
    Check.SShotRequester.ClientMessage("ACE has requested a screenshot for player:" @ Check.PlayerName);
}

// =============================================================================
// PlayerSShotEnded ~
// =============================================================================
function PlayerSShotEnded(name EventType, IACECheck Check, string EventData)
{
    local string FileName;
    local string Error;
    local string Success;
    local int i, j;

    Check.ACEPadLog("Screenshot Status", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    if (xxGetToken(EventData, ":::", 0) == "0")
    {
        Success  = "FALSE";
        Error    = xxGetToken(EventData, ":::", 1);
        FileName = xxGetToken(EventData, ":::", 2);

        if (Check.SShotRequester != none)
        {
            Check.SShotRequester.ClientMessage("ACE could not create a screenshot for player:" @ Check.PlayerName);
            Check.SShotRequester.ClientMessage("Reason:" @ Error);
            if (FileName != "")
            Check.SShotRequester.ClientMessage("FileName (possibly corrupt):" @ FileName);
            Check.SShotRequester.ClientMessage("The player is now being kicked");
            Check.SShotRequester = none;
        }
    }
    else
    {
        Success  = "TRUE";
        FileName = xxGetToken(EventData, ":::", 1);

        if (Check.SShotRequester != none)
        {
            Check.SShotRequester.ClientMessage("ACE has created a screenshot for player:" @ Check.PlayerName);
            Check.SShotRequester.ClientMessage("FileName:" @ FileName);
            Check.SShotRequester = none;
        }
    }

    Check.ACELog("Success......:" @ Success);
    if (FileName != "")
    Check.ACELog("FileName.....:" @ FileName);
    if (Error != "")
    Check.ACELog("Error........:" @ Error);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Check for pending kicks
    for (i = 0; i < 10; ++i)
    {
        if (Check.KickReason[i] != "")
        {
            Check.PlayerMessage(Check.KickReason[i]);
            j++;
        }
    }

    // There's a pending kick. Do it now!
    if (j == 0)
    {
        if (Success == "FALSE")
        {
            Check.PlayerMessage("Error while creating screenshot");
            Check.PlayerKick(true);
        }
    }
    else if (j > 0)
    {
        Check.PlayerKick(true);
    }
}

// =============================================================================
// PlayerIncompatibility - Incompatibility with a native application. Usually
// virusscanners or firewalls
// =============================================================================
function PlayerIncompatibility(name EventType, IACECheck Check, string EventData)
{
    if (Check == none || Check.bDeleteMe || Check.bKickPending) return;

    LogPlayerKick(EventType, "Incompatibility", Check);

    // Extra info
    Check.ACEPadLog("Extra Info", " ", "|", 65, false, true);
    Check.ACEPadLog("", "-", "+", 65, false, true);
    Check.ACELog("Library......:" @ EventData);
    Check.ACEPadLog("", "-", "+", 65, false, true);

    // Kick
    Check.KickReason[0] = "You have been kicked because an application is preventing ACE from operating correctly.";

    if (EventData ~= "Unknown")
    {
        Check.KickReason[1] = "ACE could not identify the application that causes the problem.";
        Check.KickReason[2] = "Try disabling your virusscanner and/or firewall and try again.";
    }
    else
    {
        Check.KickReason[1] = "Application = " $ EventData;
        Check.KickReason[2] = "Please disable this application and try again.";
    }

    if (ConfigActor.bSShotWhenKick)
    {
        Check.bKickPending = true;
        if (Check.CreateScreenshot() == 10)
            return;
    }

    Check.PlayerMessage(Check.KickReason[0]);
    Check.PlayerMessage(Check.KickReason[1]);
    Check.PlayerMessage(Check.KickReason[2]);
    Check.PlayerKick(true);
}

// =============================================================================
// getNexgenID ~ Returns the Nexgen ID for a player
// =============================================================================
function string getNexgenID(PlayerPawn P) {
  local NexgenClient PlayerClient;

  // NexgenController.
  if (NSC == none) {
	  foreach allActors(class'NexgenController', NSC)
		  break;
  }

	if(NSC == none) return "NEXGENCONTROLLER NOT FOUND!";

  PlayerClient = NSC.getClient(P);
  if(PlayerClient == none) return "CLIENT NOT FOUND!";

  return PlayerClient.playerID;
}

// =============================================================================
// defaultproperties
// =============================================================================

defaultproperties
{
     ACEVersion="v08h"
}
