SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

CREATE TABLE IF NOT EXISTS `access_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `client_id` varchar(32) NOT NULL,
  `playername` varchar(32) NOT NULL,
  `player_ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `server_name` varchar(255) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `active_guests` (
  `ip` varchar(15) NOT NULL default '',
  `timestamp` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `active_users` (
  `username` varchar(30) NOT NULL default '',
  `timestamp` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `buddy_list` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `buddy1_id` int(11) unsigned NOT NULL default '0',
  `buddy2_id` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `buddy_requests` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `requester_id` int(11) unsigned NOT NULL default '0',
  `receiver_id` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `configuration` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `configuration` (`config_name`, `config_value`) VALUES
('last_update_check', '0'),
('update_url', 'http://www.ut-slv.com/msull/universalunreal/update.php'),
('newest_version', '10905'),
('information_url', 'http://www.unrealadmin.org/forums/forumdisplay.php?f=199');

CREATE TABLE IF NOT EXISTS `private_msg` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sender_id` int(11) unsigned NOT NULL,
  `receiver_id` int(11) unsigned NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  `preamble` varchar(255) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `server_list` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `server_name` varchar(255) NOT NULL default '',
  `server_url` varchar(255) NOT NULL default '',
  `server_tcpport` int(11) NOT NULL default '0',
  `allow_local_lookup` tinyint(1) NOT NULL default '0',
  `allow_universal_lookup` tinyint(1) NOT NULL default '0',
  `gamesession` varchar(32) NOT NULL,
  `briefinfo_numplayers` tinyint(2) unsigned NOT NULL default '0',
  `briefinfo_maxplayers` tinyint(2) unsigned NOT NULL default '0',
  `briefinfo_map` varchar(255) NOT NULL default '',
  `briefinfo_timestamp` int(11) unsigned NOT NULL default '0',
  `briefinfo_cachetime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(30) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `userid` varchar(32) NOT NULL default '',
  `userlevel` tinyint(1) unsigned NOT NULL default '0',
  `email` varchar(50) NOT NULL default '',
  `timestamp` int(11) unsigned NOT NULL default '0',
  `regtimestamp` int(11) unsigned NOT NULL default '0',
  `emailnologinsent` tinyint(1) NOT NULL default '0',
  `secretq` varchar(100) NOT NULL default '',
  `answerq` varchar(100) NOT NULL default '',
  `lastserver_id` int(11) NOT NULL default '0',
  `lastserver_timestamp` int(11) unsigned NOT NULL default '0',
  `lastserver_playername` varchar(32) NOT NULL default '',
  `active_now` tinyint(1) NOT NULL default '0',
  `autoaccept_buddies` tinyint(1) NOT NULL default '0',
  `emailabout_buddies` tinyint(1) NOT NULL default '0',
  `accepted_settings` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;