/***************************************************************************************************
 *
 *  SendTo standalone by {LSN}Meindratheal
 *
 *  $CLASS        STWUtils
 *  $VERSION      1.01 (15-04-2011 18:42)
 *  $AUTHOR       {LSN}Meindratheal
 *  $DESCRIPTION  SendTo utility class. Holds static functions.
 *
 **************************************************************************************************/
class STWUtils extends Actor;

/***************************************************************************************************
 *
 *  $DESCRIPTION  Removes leading and trailing spaces from the given string.
 *  $PARAM        source  The string for which the leading and trailing spaces are to be removed.
 *  $RETURN       The original string with all spaces removed from the front and back of the string.
 *  $ENSURE       len(result) > 0 ? left(result, 1) != " " && right(result, 1) != " " : true
 *
 **************************************************************************************************/
static function string trim(string source) {
	local int index;
	local string result;
	
	// Remove leading spaces.
	result = source;
	while (index < len(result) && mid(result, index, 1) == " ") {
		index++;
	}
	result = mid(result, index);
	
	// Remove trailing spaces.
	index = len(result) - 1;
	while (index >= 0 && mid(result, index, 1) == " ") {
		index--;
	}
	result = left(result, index + 1);
	
	// Return new string.
	return result;	
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Pads a string to a given length, using the specified characters.
 *  $PARAM        S        The string to pad.
 *  $PARAM        Length   The length to pad to.
 *  $PARAM        PadStr   The character to pad out with
 *  $PARAM        EndStr   The final character to pad out with
 *  $RETURN       The original string, padded to the required length.
 *
 **************************************************************************************************/
static function string PadOut(string S, int Length, optional string PadStr, optional string EndStr)
{
	PadStr = Left(PadStr, 1);
	if(PadStr == "") PadStr = " ";
	EndStr = Left(EndStr, 1);
	if(EndStr == "") EndStr = PadStr;
	While(Len(S) < Length - 2)
	{
		if(Len(S) % 2 == 0)	S = S $ PadStr;
		else			S = PadStr $ S;
	}
	//Padded to length - 2.
	S = EndStr $ S $ EndStr;
	return S;
}