//Client actor for replicating the command.
class STWClient extends Actor;

var STWClient NextClient; //Link to next in linked list
var STWMut Control;

replication
{
	reliable if (role == ROLE_Authority) // Replicate to client...
		ClientWebConnect;
}

function Link(STWMut Mut)
{
	local STWClient C;
	Control = Mut;
	//Add to linked list.
	C = Control.ClientList;
	if(C == None)
	{
		//Add at the head of the chain.
		Control.ClientList = self;
		return;
	}
	//else
	while(C.NextClient != None)
	{
		C = C.NextClient;
	}
	//Add here.
	C.NextClient = self;
}

simulated function ClientWebConnect(string U)
{
	PlayerPawn(Owner).ConsoleCommand("start "$U);
	Destroy();
}

defaultproperties
{
  RemoteRole=ROLE_SimulatedProxy
}