// LinkedList container by James P.
// Send comments and suggestions to iamfearless@gmail.com

class LinkedList extends Object;

var private int llsize;

var private ListElement firstListElement;
var private ListElement lastProcessed;

function add( Object anObject )
{
	local ListElement le;

	if( anObject != none )
	{
		le = new class'ListElement'; // Instantiate ListElement
		le.setReference( anObject ); // Put object reference in ListElement

		if( firstListElement == none )
		{
			// Store reference to first ListElement so we can use it to get other ListElements
			firstListElement = le;
			lastProcessed = firstListElement;
		}

		// Set reference of current ListElement in the previous ListElement
		if( lastProcessed != none )
		{
			lastProcessed.setNext( le );
			lastProcessed = le;
		}

		llsize++; // Increment list size counter
	}
}

function clear()
{
	// Remove references to all ListElements and let garbage collector do it's job at map change
	firstListElement = none;
}

function bool contains( Object anObject )
{
	local ListElement le;

	if( !IsEmpty() )
	{
		le = firstListElement;

		do
		{
			if( le.getReference() == anObject )
				return true;

			le = le.getNext();
		}
		until( le == none )
	}

	return false;
}

function Object get( int index )
{
	local int i;
	local ListElement le;

	if( !IsEmpty() )
	{
		le = getListElement( index );

		if( le == none )
			return none;
		else
			return le.getReference();
	}

	return none;
}

function ListElement getListElement( int index )
{
	local int i;
	local ListElement le;

	if( !isEmpty() )
	{
		if( index == 1 )
			return firstListElement;

		le = firstListElement;

		do
		{
			le = le.getNext();

			if( le == none )
				return none;

			i++;
		}
		until( i == index-1 )

		return le;
	}

	return none;
}

function bool isEmpty()
{
	if( firstListElement == none )
		return true;
}

function removeObject( int index )
{
	local ListElement le, le2;

	if( !IsEmpty() )
	{
		if( getListElement( index ) != none )
		{
			llsize--;

			le = getListElement( index-1 ); // Get previous ListElement

			if( le != none )
			{
				le2 = getListElement( index+1 ); // Get next ListElement

				if( le2 != none )
					le.setNext( le2 );
			}
		}
	}
}

function set( Object anObject, int index )
{
	local int i;
	local ListElement le;

	if( !IsEmpty() )
	{
		le = getListElement( i );

		if( le == none )
			return;
		else
			le.setReference( anObject );
	}
}

function int size()
{
	return llsize;
}

defaultproperties
{
	llsize=0
	firstListElement=none
	lastProcessed=none
}

