class GNAT extends Mutator;


var PlayerPawn PlayerList[32];
var PRI_GNAT PlayerRIList[32];

function PostBeginPlay()
{
    Super.PostBeginPlay();
    log ("GNAT Initialized",'GNAT');
    Level.Game.RegisterMessageMutator(self);
}

function Tick(float deltaTime)
{
    local Pawn P;
	local PlayerPawn PP;
	local int i;
	local PRI_GNAT RI;

    for (i=0; i<32; i++)
	{
		P = PlayerList[i];
		RI = PlayerRIList[i];

        if (((P == None) || (P.bDeleteMe) ) && (RI != None))
		{
			PlayerList[i] = None;
			PlayerRIList[i].Destroy();
			PlayerRIList[i] = None;
			P = None;
		}
    }

	for( P = Level.PawnList; P != None; P = P.NextPawn )
    {
        if (((P.IsA('PlayerPawn')) && (!p.IsA('Spectator')) && NetConnection(PlayerPawn(P).Player) != None && (!P.IsA('MessagingSpectator'))) && (FindPIndexFor(P) == -1))
		{
			i = 0;

			while ((i<32) && (PlayerList[i] != None))
			  i++;

			PlayerList[i] = PlayerPawn(P);

			RI = Spawn(class 'PRI_GNAT',P,,P.Location);
			if (RI == None)
			{
				Log("[GNAT] -- ERROR: RI = None");
			}
			else
			{
                PlayerRIList[i] = RI;
				RI.Mut = self;
			}
		}
	}
}

function int FindPIndexFor(pawn P)
{
	local int i;

	for (i=0; i<32; i++)
	{
		if ((PlayerList[i] != None) && (PlayerList[i] == P))
			return i;
	}
	return -1;
}
